/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.serializer;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.serializer.ScalaOptionSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;

@Internal
public class OptionSerializer<A>
extends TypeSerializer<Option<A>> {
    private static final long serialVersionUID = -8635243274072627338L;
    private final TypeSerializer elemSerializer;

    public OptionSerializer(TypeSerializer<A> elemSerializer) {
        this.elemSerializer = elemSerializer;
    }

    public TypeSerializer<A> elemSerializer() {
        return this.elemSerializer;
    }

    public OptionSerializer<A> duplicate() {
        TypeSerializer duplicatedElemSerializer = this.elemSerializer().duplicate();
        if (duplicatedElemSerializer == this.elemSerializer()) {
            return this;
        }
        return new OptionSerializer<A>(duplicatedElemSerializer);
    }

    public Option<A> createInstance() {
        return None$.MODULE$;
    }

    public boolean isImmutableType() {
        return this.elemSerializer() == null || this.elemSerializer().isImmutableType();
    }

    public int getLength() {
        return -1;
    }

    public Option<A> copy(Option<A> from) {
        Option<A> option = from;
        if (option instanceof Some) {
            Object a = ((Some)option).value();
            return Some$.MODULE$.apply(this.elemSerializer().copy(a));
        }
        if (None$.MODULE$.equals(option)) {
            return from;
        }
        throw new MatchError(option);
    }

    public Option<A> copy(Option<A> from, Option<A> reuse) {
        return this.copy(from);
    }

    public void copy(DataInputView source, DataOutputView target) {
        boolean isSome = source.readBoolean();
        target.writeBoolean(isSome);
        if (isSome) {
            this.elemSerializer().copy(source, target);
            return;
        }
    }

    public void serialize(Option<A> either, DataOutputView target) {
        Option<A> option = either;
        if (option instanceof Some) {
            Object a = ((Some)option).value();
            target.writeBoolean(true);
            this.elemSerializer().serialize(a, target);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            target.writeBoolean(false);
            return;
        }
        throw new MatchError(option);
    }

    public Option<A> deserialize(DataInputView source) {
        boolean isSome = source.readBoolean();
        if (isSome) {
            return Some$.MODULE$.apply(this.elemSerializer().deserialize(source));
        }
        return None$.MODULE$;
    }

    public Option<A> deserialize(Option<A> reuse, DataInputView source) {
        return this.deserialize(source);
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof OptionSerializer) {
            OptionSerializer optionSerializer = (OptionSerializer)((Object)object);
            return this.elemSerializer().equals(optionSerializer.elemSerializer());
        }
        return false;
    }

    public int hashCode() {
        return this.elemSerializer().hashCode();
    }

    public TypeSerializerSnapshot<Option<A>> snapshotConfiguration() {
        return new ScalaOptionSerializerSnapshot(this);
    }
}

