/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.serializer;

import java.io.Serializable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.api.serializer.CollectionSerializerSnapshot;
import org.apache.flink.api.serializer.SimpleSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.IndexedSeq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class ArraySerializer<T>
extends TypeSerializerSingleton<Object>
implements SimpleSerializer<Object> {
    private final TypeSerializer child;
    private final Class<T> clazz;
    private final ClassTag classTag;

    public ArraySerializer(TypeSerializer<T> child, Class<T> clazz) {
        this.child = child;
        this.clazz = clazz;
        this.classTag = ClassTag$.MODULE$.apply(clazz);
    }

    public TypeSerializer<T> child() {
        return this.child;
    }

    public ClassTag<T> classTag() {
        return this.classTag;
    }

    public Object createInstance() {
        return Array$.MODULE$.empty(this.classTag());
    }

    public int getLength() {
        return -1;
    }

    public Object deserialize(DataInputView source) {
        int count = source.readInt();
        IndexedSeq result = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).map((Function1 & Serializable)x$1 -> this.$anonfun$1(source, BoxesRunTime.unboxToInt((Object)x$1)));
        return result.toArray(this.classTag());
    }

    public void serialize(Object record, DataOutputView target) {
        target.writeInt(ScalaRunTime$.MODULE$.array_length(record));
        Object object = Predef$.MODULE$.genericArrayOps(record);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)element -> this.child().serialize(element, target));
    }

    public TypeSerializerSnapshot<Object> snapshotConfiguration() {
        return new CollectionSerializerSnapshot(this.child(), ArraySerializer.class, this.clazz);
    }

    private final /* synthetic */ Object $anonfun$1(DataInputView source$1, int x$1) {
        int n = x$1;
        return this.child().deserialize(source$1);
    }
}

