/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api;

import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.DataStream;
import org.apache.flink.api.OutputTag;
import org.apache.flink.api.ScalaStreamOps$;
import org.apache.flink.api.StreamExecutionEnvironment;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.function.AllWindowFunction;
import org.apache.flink.api.function.ProcessAllWindowFunction;
import org.apache.flink.api.function.util.ScalaAllWindowFunction;
import org.apache.flink.api.function.util.ScalaAllWindowFunctionWrapper;
import org.apache.flink.api.function.util.ScalaProcessAllWindowFunctionWrapper;
import org.apache.flink.api.function.util.ScalaReduceFunction;
import org.apache.flink.streaming.api.functions.aggregation.AggregationFunction;
import org.apache.flink.streaming.api.functions.aggregation.ComparableAggregator;
import org.apache.flink.streaming.api.functions.aggregation.SumAggregator;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import scala.Function2;
import scala.Function3;
import scala.Predef$;
import scala.collection.Iterable;
import scala.runtime.BoxedUnit;

@Public
public class AllWindowedStream<T, W extends Window> {
    private final org.apache.flink.streaming.api.datastream.AllWindowedStream<T, W> javaStream;

    public AllWindowedStream(org.apache.flink.streaming.api.datastream.AllWindowedStream<T, W> javaStream) {
        this.javaStream = javaStream;
    }

    @PublicEvolving
    public AllWindowedStream<T, W> allowedLateness(Time lateness) {
        this.javaStream.allowedLateness(lateness);
        return this;
    }

    @PublicEvolving
    public AllWindowedStream<T, W> sideOutputLateData(OutputTag<T> outputTag) {
        this.javaStream.sideOutputLateData(outputTag);
        return this;
    }

    @PublicEvolving
    public AllWindowedStream<T, W> trigger(Trigger<? super T, ? super W> trigger) {
        this.javaStream.trigger(trigger);
        return this;
    }

    @PublicEvolving
    public AllWindowedStream<T, W> evictor(Evictor<? super T, ? super W> evictor) {
        this.javaStream.evictor(evictor);
        return this;
    }

    public DataStream<T> reduce(ReduceFunction<T> function) {
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.reduce(this.clean(function)));
    }

    public DataStream<T> reduce(Function2<T, T, T> function) {
        if (function == null) {
            throw new NullPointerException("Reduce function must not be null.");
        }
        Function2<T, T, T> cleanFun = this.clean(function);
        ScalaReduceFunction<T> reducer = new ScalaReduceFunction<T>(cleanFun);
        return this.reduce(reducer);
    }

    public <R> DataStream<R> reduce(ReduceFunction<T> preAggregator, AllWindowFunction<T, R, W> windowFunction, TypeInformation<R> evidence$1) {
        ReduceFunction<T> cleanedReducer = this.clean(preAggregator);
        AllWindowFunction<T, R, W> cleanedWindowFunction = this.clean(windowFunction);
        ScalaAllWindowFunctionWrapper<T, R, W> applyFunction = new ScalaAllWindowFunctionWrapper<T, R, W>(cleanedWindowFunction);
        TypeInformation returnType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$1);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.reduce(cleanedReducer, applyFunction, returnType));
    }

    public <R> DataStream<R> reduce(Function2<T, T, T> preAggregator, Function3<W, Iterable<T>, Collector<R>, BoxedUnit> windowFunction, TypeInformation<R> evidence$2) {
        if (preAggregator == null) {
            throw new NullPointerException("Reduce function must not be null.");
        }
        if (windowFunction == null) {
            throw new NullPointerException("WindowApply function must not be null.");
        }
        Function2<T, T, T> cleanReducer = this.clean(preAggregator);
        Function3<W, Iterable<T>, Collector<R>, BoxedUnit> cleanWindowFunction = this.clean(windowFunction);
        ScalaReduceFunction<T> reducer = new ScalaReduceFunction<T>(cleanReducer);
        ScalaAllWindowFunction<T, R, W> applyFunction = new ScalaAllWindowFunction<T, R, W>(cleanWindowFunction);
        TypeInformation returnType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$2);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.reduce(reducer, applyFunction, returnType));
    }

    @PublicEvolving
    public <R> DataStream<R> reduce(ReduceFunction<T> preAggregator, ProcessAllWindowFunction<T, R, W> windowFunction, TypeInformation<R> evidence$3) {
        ReduceFunction<T> cleanedReducer = this.clean(preAggregator);
        ProcessAllWindowFunction<T, R, W> cleanedWindowFunction = this.clean((Object)windowFunction);
        ScalaProcessAllWindowFunctionWrapper<T, R, W> applyFunction = new ScalaProcessAllWindowFunctionWrapper<T, R, W>(cleanedWindowFunction);
        TypeInformation returnType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$3);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.reduce(cleanedReducer, applyFunction, returnType));
    }

    @PublicEvolving
    public <R> DataStream<R> reduce(Function2<T, T, T> preAggregator, ProcessAllWindowFunction<T, R, W> windowFunction, TypeInformation<R> evidence$4) {
        if (preAggregator == null) {
            throw new NullPointerException("Reduce function must not be null.");
        }
        if (windowFunction == null) {
            throw new NullPointerException("WindowApply function must not be null.");
        }
        Function2<T, T, T> cleanReducer = this.clean(preAggregator);
        ProcessAllWindowFunction<T, R, W> cleanWindowFunction = this.clean((Object)windowFunction);
        ScalaReduceFunction<T> reducer = new ScalaReduceFunction<T>(cleanReducer);
        ScalaProcessAllWindowFunctionWrapper<T, R, W> applyFunction = new ScalaProcessAllWindowFunctionWrapper<T, R, W>(cleanWindowFunction);
        TypeInformation returnType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$4);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.reduce(reducer, applyFunction, returnType));
    }

    @PublicEvolving
    public <ACC, R> DataStream<R> aggregate(AggregateFunction<T, ACC, R> aggregateFunction, TypeInformation<ACC> evidence$5, TypeInformation<R> evidence$6) {
        Preconditions.checkNotNull(aggregateFunction, (String)"AggregationFunction must not be null");
        TypeInformation accumulatorType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$5);
        TypeInformation resultType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$6);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.aggregate(this.clean(aggregateFunction), accumulatorType, resultType));
    }

    @PublicEvolving
    public <ACC, V, R> DataStream<R> aggregate(AggregateFunction<T, ACC, V> preAggregator, AllWindowFunction<V, R, W> windowFunction, TypeInformation<ACC> evidence$7, TypeInformation<V> evidence$8, TypeInformation<R> evidence$9) {
        Preconditions.checkNotNull(preAggregator, (String)"AggregationFunction must not be null");
        Preconditions.checkNotNull(windowFunction, (String)"Window function must not be null");
        AggregateFunction<T, ACC, V> cleanedPreAggregator = this.clean(preAggregator);
        AllWindowFunction<V, R, W> cleanedWindowFunction = this.clean(windowFunction);
        ScalaAllWindowFunctionWrapper<V, R, W> applyFunction = new ScalaAllWindowFunctionWrapper<V, R, W>(cleanedWindowFunction);
        TypeInformation accumulatorType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$7);
        TypeInformation resultType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$9);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.aggregate(cleanedPreAggregator, applyFunction, accumulatorType, resultType));
    }

    @PublicEvolving
    public <ACC, V, R> DataStream<R> aggregate(AggregateFunction<T, ACC, V> preAggregator, ProcessAllWindowFunction<V, R, W> windowFunction, TypeInformation<ACC> evidence$10, TypeInformation<V> evidence$11, TypeInformation<R> evidence$12) {
        Preconditions.checkNotNull(preAggregator, (String)"AggregationFunction must not be null");
        Preconditions.checkNotNull(windowFunction, (String)"Window function must not be null");
        AggregateFunction<T, ACC, V> cleanedPreAggregator = this.clean(preAggregator);
        ProcessAllWindowFunction<V, R, W> cleanedWindowFunction = this.clean((Object)windowFunction);
        ScalaProcessAllWindowFunctionWrapper<V, R, W> applyFunction = new ScalaProcessAllWindowFunctionWrapper<V, R, W>(cleanedWindowFunction);
        TypeInformation accumulatorType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$10);
        TypeInformation aggregationResultType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$11);
        TypeInformation resultType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$12);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.aggregate(cleanedPreAggregator, applyFunction, accumulatorType, aggregationResultType, resultType));
    }

    @PublicEvolving
    public <ACC, V, R> DataStream<R> aggregate(AggregateFunction<T, ACC, V> preAggregator, Function3<W, Iterable<V>, Collector<R>, BoxedUnit> windowFunction, TypeInformation<ACC> evidence$13, TypeInformation<V> evidence$14, TypeInformation<R> evidence$15) {
        Preconditions.checkNotNull(preAggregator, (String)"AggregationFunction must not be null");
        Preconditions.checkNotNull(windowFunction, (String)"Window function must not be null");
        AggregateFunction<T, ACC, V> cleanPreAggregator = this.clean(preAggregator);
        Function3<W, Iterable<V>, Collector<R>, BoxedUnit> cleanWindowFunction = this.clean(windowFunction);
        ScalaAllWindowFunction<V, R, W> applyFunction = new ScalaAllWindowFunction<V, R, W>(cleanWindowFunction);
        TypeInformation accumulatorType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$13);
        TypeInformation resultType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$15);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.aggregate(cleanPreAggregator, applyFunction, accumulatorType, resultType));
    }

    @PublicEvolving
    public <R> DataStream<R> process(ProcessAllWindowFunction<T, R, W> function, TypeInformation<R> evidence$16) {
        ProcessAllWindowFunction<T, R, W> cleanedFunction = this.clean((Object)function);
        ScalaProcessAllWindowFunctionWrapper<T, R, W> javaFunction = new ScalaProcessAllWindowFunctionWrapper<T, R, W>(cleanedFunction);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.process(javaFunction, (TypeInformation)Predef$.MODULE$.implicitly(evidence$16)));
    }

    public <R> DataStream<R> apply(AllWindowFunction<T, R, W> function, TypeInformation<R> evidence$17) {
        AllWindowFunction<T, R, W> cleanedFunction = this.clean(function);
        ScalaAllWindowFunctionWrapper<T, R, W> javaFunction = new ScalaAllWindowFunctionWrapper<T, R, W>(cleanedFunction);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.apply(javaFunction, (TypeInformation)Predef$.MODULE$.implicitly(evidence$17)));
    }

    public <R> DataStream<R> apply(Function3<W, Iterable<T>, Collector<R>, BoxedUnit> function, TypeInformation<R> evidence$18) {
        Function3<W, Iterable<T>, Collector<R>, BoxedUnit> cleanedFunction = this.clean(function);
        ScalaAllWindowFunction<T, R, W> applyFunction = new ScalaAllWindowFunction<T, R, W>(cleanedFunction);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.apply(applyFunction, (TypeInformation)Predef$.MODULE$.implicitly(evidence$18)));
    }

    public DataStream<T> max(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MAX, position);
    }

    public DataStream<T> max(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MAX, field);
    }

    public DataStream<T> min(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MIN, position);
    }

    public DataStream<T> min(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MIN, field);
    }

    public DataStream<T> sum(int position) {
        return this.aggregate(AggregationFunction.AggregationType.SUM, position);
    }

    public DataStream<T> sum(String field) {
        return this.aggregate(AggregationFunction.AggregationType.SUM, field);
    }

    public DataStream<T> maxBy(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MAXBY, position);
    }

    public DataStream<T> maxBy(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MAXBY, field);
    }

    public DataStream<T> minBy(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MINBY, position);
    }

    public DataStream<T> minBy(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MINBY, field);
    }

    private DataStream<T> aggregate(AggregationFunction.AggregationType aggregationType, String field) {
        int position = ScalaStreamOps$.MODULE$.fieldNames2Indices(this.getInputType(), new String[]{field})[0];
        return this.aggregate(aggregationType, position);
    }

    public DataStream<T> aggregate(AggregationFunction.AggregationType aggregationType, int position) {
        org.apache.flink.streaming.api.datastream.AllWindowedStream<T, W> jStream = this.javaStream;
        AggregationFunction.AggregationType aggregationType2 = aggregationType;
        AggregationFunction.AggregationType aggregationType3 = AggregationFunction.AggregationType.SUM;
        AggregationFunction.AggregationType aggregationType4 = aggregationType2;
        SumAggregator reducer = !(aggregationType3 != null ? !aggregationType3.equals(aggregationType4) : aggregationType4 != null) ? new SumAggregator(position, jStream.getInputType(), jStream.getExecutionEnvironment().getConfig()) : new ComparableAggregator(position, jStream.getInputType(), aggregationType, true, jStream.getExecutionEnvironment().getConfig());
        return new DataStream(jStream.reduce((ReduceFunction)reducer));
    }

    public <F> F clean(F f) {
        return new StreamExecutionEnvironment(this.javaStream.getExecutionEnvironment()).scalaClean(f);
    }

    private TypeInformation<T> getInputType() {
        return this.javaStream.getInputType();
    }
}

