/*
 * Decompiled with CFR 0.152.
 */
package test.fitlibrary.parser;

import fitlibrary.DoFixture;
import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.ResultParser;
import fitlibrary.ref.EntityReference;
import fitlibrary.table.Cell;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.utility.TestResults;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class TestReferenceParser
extends TestCase {
    List list;
    public MyClass aProp;

    public void setUp() {
        this.list = new ArrayList();
        this.list.add(new MyClass(1));
        this.list.add(new MyClass(2));
        this.list.add(new MyClass(3));
        this.aProp = (MyClass)this.list.get(1);
    }

    public void testParseAlone() throws Exception {
        Parser parser = Traverse.asTyped(MyClass.class).parser(new MyDoFixture());
        Object first = this.list.get(0);
        this.checkReference(parser, "the", first);
        this.checkReference(parser, "the first", first);
        this.checkReference(parser, "the first MyClass", first);
        this.checkReference(parser, "the first myClass", first);
        this.checkReference(parser, "1st", first);
        TestReferenceParser.assertEquals((String)"the second MyClass", (String)parser.show(this.list.get(1)));
        TestReferenceParser.assertEquals((String)"the third MyClass", (String)parser.show(this.list.get(2)));
    }

    private void checkReference(Parser adapter, String text, Object element) throws Exception {
        Cell cell = new Cell(text);
        TestReferenceParser.assertEquals((Object)element, (Object)adapter.parseTyped(cell, new TestResults()).getSubject());
        TestReferenceParser.assertTrue((boolean)adapter.matches(cell, element, new TestResults()));
        TestReferenceParser.assertEquals((String)"the first MyClass", (String)adapter.show(element));
    }

    public void testParseFails() throws Exception {
        Parser parser = Traverse.asTyped(MyClass.class).parser(new MyDoFixture());
        this.checkReferenceFails(parser, "th");
        this.checkReferenceFails(parser, "the forst");
        this.checkReferenceFails(parser, "the first My Class");
        this.checkReferenceFails(parser, "the first myClass.");
        this.checkReferenceFails(parser, "2nd");
    }

    private void checkReferenceFails(Parser adapter, String text) {
        try {
            Cell cell = new Cell(text);
            adapter.parseTyped(cell, new TestResults());
            TestReferenceParser.fail((String)("Should throw and exception with '" + text + "'"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testParseWithMethod() throws Exception {
        Method method = ((Object)((Object)this)).getClass().getMethod("aMethod", new Class[0]);
        ResultParser adapter = Traverse.asTypedObject((Object)this).resultParser((Evaluator)new MyDoFixture(), method);
        adapter.setTarget((Object)this);
        TestReferenceParser.assertEquals(this.list.get(2), (Object)adapter.getResult());
        TestReferenceParser.assertEquals((String)"the third MyClass", (String)adapter.show(adapter.getResult()));
    }

    public MyClass aMethod() {
        return (MyClass)this.list.get(2);
    }

    public static class MyClass {
        private int value;

        public MyClass(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return "MyClass-" + this.value;
        }
    }

    public class MyDoFixture
    extends DoFixture {
        public MyClass findMyClass(int index) {
            return (MyClass)TestReferenceParser.this.list.get(index);
        }

        public MyClass findMyClass(String text) {
            if ("1st".equals(text)) {
                return this.findMyClass(0);
            }
            throw new RuntimeException("Unavailable: MyClass from '" + text + "'");
        }

        public String showMyClass(MyClass object) {
            return EntityReference.reference(object, TestReferenceParser.this.list);
        }

        public MyClass aMethod() {
            return (MyClass)TestReferenceParser.this.list.get(2);
        }
    }
}

