/*
 * Decompiled with CFR 0.152.
 */
package test.fitlibrary;

import fit.Counts;
import fit.Parse;
import fit.exception.FitParseException;
import fitlibrary.DoFixture;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.utility.TestResults;
import junit.framework.TestCase;

public class TestParseTables
extends TestCase {
    private Tables tables;
    private Counts counts;
    private TestResults testResults;

    public void setUp() throws FitParseException {
        this.tables = new Tables(new Parse("<table><tr><td>1</td></tr><tr><td>2</td><td>3</td></tr></table>\n<table><tr><td>1</td></tr><tr><td>2</td><td>3</td></tr></table>\n<table><tr><td>1</td></tr><tr><td>2</td><td>3</td></tr></table>\n"));
        this.counts = new Counts();
        this.testResults = new TestResults(this.counts);
    }

    public void testTables() {
        TestParseTables.assertEquals((int)3, (int)this.tables.size());
    }

    public void testTable0() {
        Table table = this.tables.table(0);
        TestParseTables.assertEquals((int)2, (int)table.size());
        TestParseTables.assertTrue((!table.rowExists(-1) ? 1 : 0) != 0);
        TestParseTables.assertTrue((boolean)table.rowExists(0));
        TestParseTables.assertTrue((boolean)table.rowExists(1));
        TestParseTables.assertTrue((!table.rowExists(2) ? 1 : 0) != 0);
        TestParseTables.assertEquals((Object)table.row(1), (Object)table.lastRow());
        try {
            table.row(2);
            TestParseTables.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testTable0Right() {
        Table table0 = this.tables.table(0);
        table0.pass(this.testResults);
        TestParseTables.assertTrue((boolean)table0.didPass());
        TestParseTables.assertEquals((String)"1 right, 0 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testTable0Wrong() {
        Table table0 = this.tables.table(0);
        table0.fail(this.testResults);
        TestParseTables.assertTrue((boolean)table0.didFail());
        TestParseTables.assertEquals((String)"0 right, 1 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testTable0Missing() {
        Table table0 = this.tables.table(0);
        table0.missing(this.testResults);
        TestParseTables.assertTrue((boolean)table0.row(0).cell(0).didFail());
        TestParseTables.assertEquals((String)"1 missing", (String)table0.row(0).text(0));
        TestParseTables.assertEquals((String)"0 right, 1 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testTable0Ignored() {
        Table table0 = this.tables.table(0);
        table0.ignore(this.testResults);
        TestParseTables.assertTrue((boolean)table0.row(0).cell(0).wasIgnored());
        TestParseTables.assertEquals((String)"0 right, 0 wrong, 1 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testTable0Exception() {
        Table table0 = this.tables.table(0);
        table0.error(this.testResults, (Throwable)new RuntimeException("Forced"));
        TestParseTables.assertTrue((boolean)table0.row(0).cell(0).hadError());
        TestParseTables.assertTrue((boolean)table0.row(0).text(0).startsWith("1java.lang.RuntimeException: Forced"));
        TestParseTables.assertEquals((String)"0 right, 0 wrong, 0 ignored, 1 exceptions", (String)this.counts.toString());
    }

    public void testRow0() {
        Row row = this.getRow(0, 0);
        TestParseTables.assertEquals((int)1, (int)row.size());
        TestParseTables.assertTrue((!row.cellExists(-1) ? 1 : 0) != 0);
        TestParseTables.assertTrue((boolean)row.cellExists(0));
        TestParseTables.assertTrue((!row.cellExists(1) ? 1 : 0) != 0);
        try {
            row.cell(1);
            TestParseTables.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestParseTables.assertEquals((String)"1", (String)row.text(0));
    }

    public void testRow0Right() {
        Row row0 = this.getRow(0, 0);
        row0.pass(this.testResults);
        TestParseTables.assertTrue((boolean)row0.didPass());
        TestParseTables.assertEquals((String)"1 right, 0 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testRow0Wrong() {
        Row row0 = this.getRow(0, 0);
        row0.fail(this.testResults);
        TestParseTables.assertTrue((boolean)row0.didFail());
        TestParseTables.assertEquals((String)"0 right, 1 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testRow0Missing() {
        Row row0 = this.getRow(0, 0);
        row0.missing(this.testResults);
        TestParseTables.assertTrue((boolean)row0.cell(0).didFail());
        TestParseTables.assertEquals((String)"1 missing", (String)row0.text(0));
        TestParseTables.assertEquals((String)"0 right, 1 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testRow0Ignored() {
        Row row0 = this.getRow(0, 0);
        row0.ignore(this.testResults);
        TestParseTables.assertTrue((boolean)row0.cell(0).wasIgnored());
        TestParseTables.assertEquals((String)"0 right, 0 wrong, 1 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testRow0Exception() {
        Row row0 = this.getRow(0, 0);
        DoFixture doFixture = new DoFixture();
        doFixture.counts = this.counts;
        row0.error(this.testResults, new RuntimeException("Forced"));
        TestParseTables.assertTrue((boolean)row0.cell(0).hadError());
        TestParseTables.assertTrue((boolean)row0.text(0).startsWith("1java.lang.RuntimeException: Forced"));
        TestParseTables.assertEquals((String)"0 right, 0 wrong, 0 ignored, 1 exceptions", (String)this.counts.toString());
    }

    public void testCell0Text() {
        TestParseTables.assertEquals((String)"1", (String)this.getCell(0, 0, 0).text());
        TestParseTables.assertEquals((String)"0 right, 0 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testCell0Right() {
        Cell cell0 = this.getCell(0, 0, 0);
        cell0.pass(this.testResults);
        TestParseTables.assertTrue((boolean)cell0.didPass());
        TestParseTables.assertEquals((String)"1 right, 0 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testCell0Wrong() {
        Cell cell0 = this.getCell(0, 0, 0);
        cell0.fail(this.testResults);
        TestParseTables.assertTrue((boolean)cell0.didFail());
        TestParseTables.assertEquals((String)"0 right, 1 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testCell0Missing() {
        Cell cell0 = this.getCell(0, 0, 0);
        cell0.expectedElementMissing(this.testResults);
        TestParseTables.assertTrue((boolean)cell0.didFail());
        TestParseTables.assertEquals((String)"1 missing", (String)cell0.text());
        TestParseTables.assertEquals((String)"0 right, 1 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testCell0Ignored() {
        Cell cell0 = this.getCell(0, 0, 0);
        cell0.ignore(this.testResults);
        TestParseTables.assertTrue((boolean)cell0.wasIgnored());
        TestParseTables.assertEquals((String)"0 right, 0 wrong, 1 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testCell0Exception() {
        Cell cell0 = this.getCell(0, 0, 0);
        DoFixture doFixture = new DoFixture();
        doFixture.counts = this.counts;
        cell0.error(this.testResults, new RuntimeException("Forced"));
        TestParseTables.assertTrue((boolean)cell0.hadError());
        TestParseTables.assertTrue((boolean)cell0.text().startsWith("1java.lang.RuntimeException: Forced"));
        TestParseTables.assertEquals((String)"0 right, 0 wrong, 0 ignored, 1 exceptions", (String)this.counts.toString());
    }

    private Cell getCell(int tableNo, int rowNo, int cellNo) {
        return this.getRow(tableNo, rowNo).cell(cellNo);
    }

    private Row getRow(int tableNo, int rowNo) {
        return this.tables.table(tableNo).row(rowNo);
    }
}

