/*
 * Decompiled with CFR 0.152.
 */
package test.fitlibrary;

import fitlibrary.utility.CollectionUtility;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;

public class TestCollectionUtility
extends TestCase {
    public void testNoneAndNone() {
        Iterator iterator = this.none().iterator();
        this.equ(iterator, iterator);
        this.equ(iterator, this.none().iterator());
    }

    public void testOneAndOne() {
        ArrayList one = this.one();
        Iterator iterator = one.iterator();
        this.equ(iterator, iterator);
        this.equ(iterator, new ArrayList(one).iterator());
    }

    public void testOneAndNone() {
        this.notEqu(this.one().iterator(), this.none().iterator());
    }

    public void testTwoAndTwo() {
        ArrayList two = this.two();
        Iterator iterator = two.iterator();
        this.equ(iterator, iterator);
        this.equ(iterator, new ArrayList(two).iterator());
    }

    public void testTwoAndOne() {
        this.notEqu(this.two().iterator(), this.one().iterator());
    }

    public void testTwoAndNone() {
        this.notEqu(this.two().iterator(), this.none().iterator());
    }

    private ArrayList none() {
        return new ArrayList();
    }

    private ArrayList one() {
        ArrayList list = this.none();
        list.add("one");
        return list;
    }

    private ArrayList two() {
        ArrayList list = this.one();
        list.add("two");
        return list;
    }

    private void equ(Iterator iterator2, Iterator iterator) {
        TestCollectionUtility.assertTrue((boolean)this.eq(iterator, iterator2));
        TestCollectionUtility.assertTrue((boolean)this.eq(iterator2, iterator2));
    }

    private void notEqu(Iterator iterator2, Iterator iterator) {
        TestCollectionUtility.assertFalse((boolean)this.eq(iterator, iterator2));
        TestCollectionUtility.assertFalse((boolean)this.eq(iterator2, iterator));
    }

    private boolean eq(Iterator iterator, Iterator iterator2) {
        return CollectionUtility.equalsIterator(iterator, iterator2);
    }
}

