/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.typed;

import fitlibrary.closure.CalledMethodTarget;
import fitlibrary.closure.Closure;
import fitlibrary.closure.LookupClosure;
import fitlibrary.closure.LookupMethodTarget;
import fitlibrary.exception.method.MissingMethodException;
import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.FieldParser;
import fitlibrary.parser.lookup.GetterParser;
import fitlibrary.parser.lookup.ResultParser;
import fitlibrary.traverse.DomainAdapter;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.NonGenericTyped;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.ExtendedCamelCase;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class NonGenericTypedObject
implements TypedObject {
    protected Object subject;

    public NonGenericTypedObject(Object subject) {
        this.subject = subject;
    }

    public Object getSubject() {
        return this.subject;
    }

    public CalledMethodTarget findSpecificMethodOrPropertyGetter(String name, int argCount, Evaluator evaluator, String signature) {
        CalledMethodTarget result = this.optionallyFindMethodOnTypedObject(name, argCount, evaluator, true);
        if (result != null) {
            return result;
        }
        try {
            if (argCount == 0) {
                return this.findGetterOnTypedObject(name, evaluator);
            }
        }
        catch (MissingMethodException e) {
            // empty catch block
        }
        throw new MissingMethodException(signature, LookupMethodTarget.identifiedClassesInSUTChain(this.subject), "");
    }

    public CalledMethodTarget findGetterOnTypedObject(String propertyName, Evaluator evaluator) {
        CalledMethodTarget target = this.optionallyFindGetterOnTypedObject(propertyName, evaluator);
        if (target != null) {
            return target;
        }
        throw new MissingMethodException("public ResultType " + ExtendedCamelCase.camel("get " + propertyName) + "() { }" + "OR: public ResultType " + ExtendedCamelCase.camel("is " + propertyName) + "() { }", LookupMethodTarget.identifiedClassesInSUTChain(this.subject), "DomainObject");
    }

    public CalledMethodTarget optionallyFindGetterOnTypedObject(String propertyName, Evaluator evaluator) {
        String getMethodName = ExtendedCamelCase.camel("get " + propertyName);
        CalledMethodTarget target = this.optionallyFindMethodOnTypedObject(getMethodName, 0, evaluator, true);
        if (target == null) {
            String isMethodName = ExtendedCamelCase.camel("is " + propertyName);
            target = this.optionallyFindMethodOnTypedObject(isMethodName, 0, evaluator, true);
        }
        return target;
    }

    public CalledMethodTarget optionallyFindMethodOnTypedObject(String name, int argCount, Evaluator evaluator, boolean includeSut) {
        Closure methodClosure = this.findMethodClosure(name, argCount, includeSut);
        if (methodClosure == null) {
            return null;
        }
        return new CalledMethodTarget(methodClosure, evaluator);
    }

    public Closure findMethodClosure(String name, int argCount, boolean includeSut) {
        DomainAdapter domainAdapter;
        Object nestedSystemUnderTest;
        Evaluator evaluator;
        Object sut;
        if (this.subject == null) {
            return null;
        }
        Closure methodClosure = LookupClosure.findMethodClosure(this, name, argCount);
        if (methodClosure == null && this.subject instanceof Evaluator && (sut = (evaluator = (Evaluator)this.subject).getSystemUnderTest()) != null && (includeSut || sut instanceof DomainAdapter)) {
            methodClosure = evaluator.getTypedSystemUnderTest().findMethodClosure(name, argCount, includeSut);
        }
        if (methodClosure == null && this.subject instanceof DomainAdapter && (nestedSystemUnderTest = (domainAdapter = (DomainAdapter)this.subject).getSystemUnderTest()) != null && (includeSut || nestedSystemUnderTest instanceof DomainAdapter)) {
            return this.asTypedObject(nestedSystemUnderTest).findMethodClosure(name, argCount, includeSut);
        }
        return methodClosure;
    }

    protected TypedObject asTypedObject(Object sut) {
        return new NonGenericTypedObject(sut);
    }

    public Closure findPublicMethodClosureForTypedObject(String name, Class[] argTypes) {
        return LookupClosure.findPublicMethodClosure(this, name, argTypes);
    }

    public Closure findMethodForTypedObject(String name, int argCount) {
        if (this.subject == null) {
            return null;
        }
        Closure chosenMethod = LookupClosure.findMethodClosure(this, name, argCount);
        if (chosenMethod == null && this.subject instanceof DomainAdapter) {
            DomainAdapter domainAdapter = (DomainAdapter)this.subject;
            chosenMethod = this.asTypedObject(domainAdapter.getSystemUnderTest()).findMethodForTypedObject(name, argCount);
        }
        if (chosenMethod == null && this.subject instanceof Evaluator) {
            Evaluator evaluator = (Evaluator)this.subject;
            chosenMethod = this.asTypedObject(evaluator.getNextOuterContext()).findMethodForTypedObject(name, argCount);
        }
        return chosenMethod;
    }

    public String toString() {
        return "NonGenericTypedObject[" + this.subject + "]";
    }

    public Class getClassType() {
        return this.subject.getClass();
    }

    public ResultParser resultParser(Evaluator evaluator, Method method) {
        Typed resultTyped = this.resultTyped(method);
        return new GetterParser(this.getTyped().on(evaluator, resultTyped, true), method);
    }

    public ResultParser resultParser(Evaluator evaluator, Field field) {
        Typed resultTyped = this.resultTyped(field);
        return new FieldParser(this.getTyped().on(evaluator, resultTyped, true), field);
    }

    public ResultParser resultParser(Evaluator evaluator, Method method, Class actualResultType) {
        NonGenericTyped resultTyped = new NonGenericTyped(actualResultType, true);
        return new GetterParser(this.getTyped().on(evaluator, resultTyped, true), method);
    }

    public ResultParser resultParser(Evaluator evaluator, Field field, Class actualResultType) {
        NonGenericTyped resultTyped = new NonGenericTyped(actualResultType, true);
        return new FieldParser(this.getTyped().on(evaluator, resultTyped, true), field);
    }

    protected Typed resultTyped(Method method) {
        return new NonGenericTyped(method.getReturnType(), true);
    }

    protected Typed resultTyped(Field field) {
        return new NonGenericTyped(field.getType(), true);
    }

    public Parser[] parameterParsers(Evaluator evaluator, Method method) {
        Class<?>[] types = method.getParameterTypes();
        Parser[] parameterParsers = new Parser[types.length];
        for (int i = 0; i < types.length; ++i) {
            Typed parameterTyped = this.parameterTyped(method, i);
            parameterParsers[i] = this.getTyped().on(evaluator, parameterTyped, false);
        }
        return parameterParsers;
    }

    protected Typed getTyped() {
        return new NonGenericTyped(this.subject.getClass());
    }

    protected Typed parameterTyped(Method method, int parameterNo) {
        return new NonGenericTyped(method.getParameterTypes()[parameterNo], true);
    }

    public TypedObject asReturnTypedObject(Object object, Method method) {
        return new NonGenericTypedObject(object);
    }

    public TypedObject asReturnTypedObject(Object object, Field field) {
        return new NonGenericTypedObject(object);
    }

    public Evaluator traverse(Evaluator evaluator) {
        return this.getTyped().parser(evaluator).traverse(this);
    }
}

