/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.suite.BatchFitLibrary;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.Traverse;
import fitlibrary.utility.ParseUtility;
import fitlibrary.utility.TableListener;
import fitlibrary.utility.TestResults;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DefineTemplateTraverse
extends Traverse {
    private Tables body;

    public DefineTemplateTraverse() {
    }

    public Object interpret(Table table, TestResults testResults) {
        Row header = table.row(1);
        HashSet<String> parameterNames = new HashSet<String>();
        for (int c = 0; c < header.size(); ++c) {
            Cell parameterCell = header.cell(c);
            String parameterName = parameterCell.text();
            if (parameterNames.contains(parameterName)) {
                parameterCell.error(testResults, new FitLibraryException("Duplicate parameter names"));
            }
            parameterNames.add(parameterName);
        }
        return null;
    }

    protected DefineTemplateTraverse(Table defTable, int parameterCount) {
        Row header = defTable.row(1);
        if (header.size() != parameterCount) {
            throw new FitLibraryException("Mismatch in number of parameters to template");
        }
        HashMap<String, String> mapToRef = new HashMap<String, String>();
        for (int c = 0; c < header.size(); ++c) {
            mapToRef.put(header.text(c), this.paramRef(c));
        }
        this.body = new Tables(ParseUtility.copyParse(defTable.row(2).cell(0).innerTables().parse()));
        this.macroReplace(this.body, mapToRef);
    }

    public Tables call(List parameters, TestResults results) {
        Tables copy = new Tables(ParseUtility.copyParse(this.body.parse()));
        HashMap mapFromRef = new HashMap();
        for (int i = 0; i < parameters.size(); ++i) {
            mapFromRef.put(this.paramRef(i), parameters.get(i));
        }
        this.macroReplace(copy, mapFromRef);
        new BatchFitLibrary(new TableListener(results)).doTables(copy);
        return copy;
    }

    private void macroReplace(Tables tables, Map mapToRef) {
        ArrayList reverseSortOrder = new ArrayList(mapToRef.keySet());
        Collections.sort(reverseSortOrder, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                int cmpResult = ((String)arg1).compareTo((String)arg0);
                return cmpResult;
            }
        });
        for (int t = 0; t < tables.size(); ++t) {
            Table table = tables.table(t);
            for (int r = 0; r < table.size(); ++r) {
                Row row = table.row(r);
                for (int c = 0; c < row.size(); ++c) {
                    Cell cell = row.cell(c);
                    String text = cell.text();
                    for (String s : reverseSortOrder) {
                        text = text.replaceAll(s, (String)mapToRef.get(s));
                    }
                    if (text.equals(cell.text())) continue;
                    cell.setText(text);
                }
            }
        }
    }

    private String paramRef(int c) {
        return "%__%" + c + "%__%";
    }
}

