/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fit.Parse;
import fitlibrary.exception.table.MissingRowException;
import fitlibrary.table.ParseNode;
import fitlibrary.table.Row;
import fitlibrary.table.Tables;
import fitlibrary.utility.ParseUtility;
import fitlibrary.utility.TableListener;
import fitlibrary.utility.TestResults;

public class Table
extends ParseNode {
    private int firstErrorRow = 0;

    public Table() {
        super(new Parse("table", "", null, null));
    }

    public Table(Parse parse) {
        super(parse);
    }

    public Table(Row row) {
        super(new Parse("table", "", row.parse, null));
    }

    public int size() {
        return this.parse.parts.size();
    }

    public Row row(int i) {
        if (!this.rowExists(i)) {
            throw new MissingRowException("");
        }
        return new Row(this.parse.parts.at(i));
    }

    public boolean rowExists(int i) {
        return i >= 0 && i < this.size();
    }

    public String toString() {
        return "Table[" + ParseUtility.toString(this.parse.parts) + "]";
    }

    public void wrong(TestResults testResults, String msg) {
        this.row(this.firstErrorRow).cell(0).fail(testResults, msg);
    }

    public void missing(TestResults testResults) {
        this.row(this.firstErrorRow).missing(testResults);
    }

    public void ignore(TestResults testResults) {
        this.row(this.firstErrorRow).ignore(testResults);
    }

    public void error(TestResults testResults, Throwable e) {
        this.row(this.firstErrorRow).error(testResults, e);
    }

    public void error(TableListener tableListener, Exception e) {
        this.error(tableListener.getTestResults(), (Throwable)e);
    }

    public Row lastRow() {
        return this.row(this.size() - 1);
    }

    public void addRow(Row row) {
        if (this.parse.parts == null) {
            this.parse.parts = row.parse;
        } else {
            this.parse.parts.last().more = row.parse;
        }
    }

    public Row newRow() {
        Row row = new Row();
        this.addRow(row);
        return row;
    }

    public void finished(TableListener listener) {
        listener.tableFinished(this);
    }

    public Table withDummyFirstRow() {
        Parse firstRow = new Parse("tr", "", new Parse("td", "empty", null, null), this.parse.parts);
        Parse pseudoTable = new Parse("table", "", firstRow, null);
        Table table = new Table(pseudoTable);
        table.setFirstRowIsHidden();
        return table;
    }

    private void setFirstRowIsHidden() {
        this.firstErrorRow = 1;
        this.row(0).setIsHidden();
    }

    public Parse parse() {
        return this.parse;
    }

    public int phaseBreaks() {
        int count = 0;
        int hr = 0;
        while ((hr = this.parse.leader.indexOf("<hr>", hr)) >= 0) {
            ++hr;
            ++count;
        }
        return count;
    }

    public int phaseBoundaryCount() {
        return (this.parse.leader + "|").split("<hr>").length - 1;
    }

    public void addToLeader(String s) {
        this.parse.leader = this.parse.leader + s;
    }

    public void removeNext() {
        this.parse.more = this.parse.more.more;
    }

    public String getLeading() {
        return this.parse.leader;
    }

    public String getTrailing() {
        return this.parse.trailer;
    }

    public Tables getTables() {
        return new Tables(this.parse);
    }

    public void insertTable(int offset, Table table) {
        table.evenUpRows();
        Parse insertPoint = this.parse.at(offset);
        table.parse().more = insertPoint.more;
        insertPoint.more = table.parse();
    }

    public void evenUpRows() {
        int r;
        int max = 0;
        for (r = 0; r < this.size(); ++r) {
            max = Math.max(max, this.row(r).size());
        }
        for (r = 0; r < this.size(); ++r) {
            Row row = this.row(r);
            if (row.size() >= max) continue;
            row.lastCell().extraColumns(max - row.size());
        }
    }
}

