/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fit.Fixture;
import fit.Parse;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.exception.IgnoredException;
import fitlibrary.exception.table.NestedTableExpectedException;
import fitlibrary.exception.table.SingleNestedTableExpected;
import fitlibrary.table.ParseNode;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.Traverse;
import fitlibrary.utility.ParseUtility;
import fitlibrary.utility.TestResults;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;

public class Cell
extends ParseNode {
    private boolean cellIsInHiddenRow = false;

    public Cell(Parse parse) {
        super(parse);
    }

    public Cell() {
        this("");
    }

    public Cell(String cellText) {
        this(new Parse("td", cellText, null, null));
    }

    public Cell(String cellText, int cols) {
        this(new Parse("td colspan=" + cols, cellText, null, null));
    }

    public Cell(Tables innerTables) {
        this(new Parse("td", "", innerTables.parse, null));
    }

    public String text() {
        if (this.parse.body == null) {
            return "";
        }
        return this.parse.text();
    }

    public String textLower() {
        return this.text().toLowerCase();
    }

    public boolean matchesText(String text) {
        return this.text().toLowerCase().equals(text.toLowerCase());
    }

    public boolean isBlank() {
        return this.text().equals("");
    }

    public boolean hasEmbeddedTable() {
        return this.parse.parts != null;
    }

    public Tables innerTables() {
        if (!this.hasEmbeddedTable()) {
            throw new NestedTableExpectedException();
        }
        return new Tables(this.parse.parts);
    }

    public Cell copy() {
        return new Cell(ParseUtility.copyParse(this.parse));
    }

    public boolean equals(Object object) {
        if (!(object instanceof Cell)) {
            return false;
        }
        Cell other = (Cell)object;
        return this.parse.body.equals(other.parse.body);
    }

    public void fail(TestResults testResults, String msg) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        this.fail(testResults);
        this.addToBody(Cell.label("expected") + "<hr>" + Fixture.escape((String)msg) + Cell.label("actual"));
    }

    public void expectedElementMissing(TestResults testResults) {
        this.fail(testResults);
        this.addToBody(Cell.label("missing"));
    }

    public void actualElementMissing(TestResults testResults) {
        this.fail(testResults);
        this.addToBody(Cell.label("surplus"));
    }

    public void actualElementMissing(TestResults testResults, String value) {
        this.fail(testResults);
        this.parse.body = Fixture.gray((String)Fixture.escape((String)value.toString()));
        this.addToBody(Cell.label("surplus"));
    }

    public void pass(TestResults testResults) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        super.pass(testResults);
    }

    public void fail(TestResults testResults) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        super.fail(testResults);
    }

    public void error(TestResults testResults, Throwable e) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        this.ensureBodyNotNull();
        this.addToBody(Cell.exceptionMessage(e));
        this.parse.addToTag(" class=\"error\"");
        testResults.exception();
    }

    private static String exceptionMessage(Throwable exception) {
        while (exception.getClass().equals(InvocationTargetException.class)) {
            exception = ((InvocationTargetException)exception).getTargetException();
        }
        if (exception instanceof IgnoredException) {
            return "";
        }
        if (exception instanceof FitLibraryException) {
            return "<hr/>" + Fixture.label((String)Traverse.escapeHtml(exception.getMessage()));
        }
        StringWriter buf = new StringWriter();
        exception.printStackTrace(new PrintWriter(buf));
        return "<hr><pre><div class=\"fit_stacktrace\">" + buf.toString() + "</div></pre>";
    }

    public void ignore(TestResults testResults) {
        if (this.cellIsInHiddenRow) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        this.ensureBodyNotNull();
        if (this.parse.tag.indexOf("class") >= 0) {
            throw new RuntimeException("Duplicate cell class in tag. Tag is already" + this.parse.tag.substring(1, this.parse.tag.length() - 2));
        }
        this.parse.addToTag(" class=\"ignore\"");
        testResults.ignore();
    }

    public Table getEmbeddedTable() {
        Tables tables = this.getEmbeddedTables();
        if (tables.size() != 1) {
            throw new SingleNestedTableExpected();
        }
        return tables.table(0);
    }

    public Tables getEmbeddedTables() {
        if (!this.hasEmbeddedTable()) {
            throw new NestedTableExpectedException();
        }
        return new Tables(this.parse.parts);
    }

    public String toString() {
        if (this.hasEmbeddedTable()) {
            return "Cell[" + ParseUtility.toString(this.parse.parts) + "]";
        }
        return this.text();
    }

    public void wrongHtml(TestResults counts, String actual) {
        this.fail(counts);
        this.addToBody(Cell.label("expected") + "<hr>" + actual + Cell.label("actual"));
    }

    private void addToBody(String msg) {
        if (this.hasEmbeddedTable()) {
            if (this.parse.parts.more == null) {
                this.parse.parts.trailer = msg;
            } else {
                this.parse.parts.more.leader = this.parse.parts.more.leader + msg;
            }
        } else {
            this.parse.addToBody(msg);
        }
    }

    public void setText(String text) {
        this.parse.body = text;
    }

    public String fullText() {
        return this.parse.body;
    }

    public void setUnvisitedEscapedText(String s) {
        this.setUnvisitedText(Fixture.escape((String)s));
    }

    public void setUnvisitedText(String s) {
        this.setText(Fixture.gray((String)s));
    }

    public void passIfBlank(TestResults counts) {
        if (this.isBlank()) {
            this.pass(counts);
        } else {
            this.fail(counts, "");
        }
    }

    public void passIfNotEmbedded(TestResults counts) {
        if (!this.hasEmbeddedTable()) {
            this.pass(counts);
        }
    }

    public void setIsHidden() {
        this.cellIsInHiddenRow = true;
    }

    public void setInnerTables(Tables tables) {
        this.parse.parts = tables.parse();
    }

    public void extraColumns(int i) {
        this.parse.addToTag(" colspan=\"" + (i + 1) + "\"");
    }
}

