/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.suite;

import fitlibrary.closure.CalledMethodTarget;
import fitlibrary.suite.FlowControl;
import fitlibrary.suite.InFlowPageRunner;
import fitlibrary.suite.SuiteEvaluator;
import fitlibrary.suite.SuiteRunner;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.workflow.DoEvaluator;
import fitlibrary.typed.NonGenericTypedFactory;
import fitlibrary.utility.TableListener;
import fitlibrary.utility.TestResults;

public class IntegratedSuiteRunner
implements SuiteRunner {
    private SuiteEvaluator suiteEvaluator;
    protected boolean abandoned = false;

    public IntegratedSuiteRunner(SuiteEvaluator suiteEvaluator) {
        this.suiteEvaluator = suiteEvaluator;
        suiteEvaluator.registerFlowControl(new FlowControl(){

            public void abandon() {
                IntegratedSuiteRunner.this.abandoned = true;
            }

            public void setStopOnError(boolean stopOnError) {
            }
        });
    }

    public void runFirstStorytest(Tables tables, TableListener tableListener) {
        Table firstTable = tables.table(0);
        this.suiteMethod("suiteSetUp", firstTable, tableListener.getTestResults());
        this.suiteEvaluator.interpret(firstTable, tableListener.getTestResults());
        tableListener.tableFinished(firstTable);
        this.runEachStorytest(tables, 1, tableListener);
    }

    private void suiteMethod(String methodName, Table firstTable, TestResults results) {
        try {
            CalledMethodTarget methodTarget = new NonGenericTypedFactory().asTypedObject(this.suiteEvaluator).optionallyFindMethodOnTypedObject(methodName, 0, this.suiteEvaluator, false);
            if (methodTarget != null) {
                methodTarget.invoke();
            }
        }
        catch (Exception e) {
            firstTable.error(results, (Throwable)e);
        }
    }

    public void runStorytest(Tables tables, TableListener tableListener) {
        this.runEachStorytest(tables, 0, tableListener);
    }

    private void runEachStorytest(Tables tables, int fromTable, TableListener tableListener) {
        this.abandoned = false;
        for (int i = fromTable; i < tables.size(); ++i) {
            Table table = tables.table(i);
            if (this.abandoned) {
                tableListener.tableFinished(table);
                continue;
            }
            TestResults testResults = tableListener.getTestResults();
            Object result = this.suiteEvaluator.interpretWholeTable(table, tableListener);
            tableListener.tableFinished(table);
            if (this.abandoned) {
                table.ignore(testResults);
            }
            if (!(result instanceof DoEvaluator)) continue;
            DoEvaluator doEvaluator = (DoEvaluator)result;
            new InFlowPageRunner(doEvaluator, this.abandoned).run(tables, i + 1, tableListener);
            break;
        }
        tableListener.storytestFinished();
    }

    public void exit() {
        Row row = new Row();
        row.addCell();
        this.suiteMethod("suiteTearDown", new Table(row), new TestResults());
    }
}

