/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.suite;

import fitlibrary.suite.FlowControl;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.workflow.DoEvaluator;
import fitlibrary.utility.TableListener;
import fitlibrary.utility.TestResults;

public class InFlowPageRunner {
    private DoEvaluator doEvaluator;
    boolean abandoned = false;
    private boolean stopOnError = false;

    public InFlowPageRunner(DoEvaluator doEvaluator, boolean abandoned) {
        this.doEvaluator = doEvaluator;
        this.abandoned = abandoned;
        doEvaluator.registerFlowControl(new FlowControl(){

            public void abandon() {
                InFlowPageRunner.this.abandoned = true;
            }

            public void setStopOnError(boolean stopOnError) {
            }
        });
    }

    public void run(Tables tables, int from, TableListener tableListener) {
        this.doEvaluator.doNotTearDownAutomatically();
        TestResults testResults = tableListener.getTestResults();
        for (int i = from; i < tables.size(); ++i) {
            Table table = tables.table(i);
            if (this.abandoned || this.stopOnError && testResults.problems()) {
                table.ignore(testResults);
            } else {
                this.doEvaluator.interpretWholeTable(table, tableListener);
            }
            tableListener.tableFinished(table);
        }
        this.doEvaluator.tearDown(tables.table(0), testResults);
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    public void setAbandon(boolean abandoned) {
        this.abandoned = abandoned;
    }
}

