/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spec;

import fit.Fixture;
import fit.Parse;
import fit.exception.FitParseException;
import fitlibrary.suite.BatchFitLibrary;
import fitlibrary.table.Tables;
import fitlibrary.utility.ParseUtility;

public class SpecifyFixture
extends Fixture {
    public void doTable(Parse table) {
        Parse firstRow = table.parts.more;
        Parse actual = firstRow.parts.parts;
        Parse secondRow = firstRow.more;
        Parse expectedCell = secondRow != null ? secondRow.parts : firstRow.parts.more;
        Parse expected = expectedCell.parts;
        new BatchFitLibrary().doTables(new Tables(actual));
        if (SpecifyFixture.reportsEqual(actual, expected)) {
            this.right(expectedCell);
            this.counts.right += this.cellCount(actual) - 1;
        } else {
            this.wrong(expectedCell);
            ParseUtility.printParse(actual, "actual");
            this.addTableToBetterShowDifferences(table, actual, expected);
        }
    }

    private int cellCount(Parse parse) {
        if (parse == null) {
            return 0;
        }
        int count = 0;
        if (parse.parts == null) {
            count = 1;
        }
        return count + this.cellCount(parse.parts) + this.cellCount(parse.more);
    }

    protected void addTableToBetterShowDifferences(Parse table, Parse actual, Parse expected) {
        Parse end = table.last();
        Parse cells1 = new Parse("td", "fitlibrary.CommentFixture", null, null);
        Parse cells2 = new Parse("td", "actual", null, new Parse("td", "expected", null, null));
        Parse cells3 = new Parse("td", SpecifyFixture.show(actual), null, new Parse("td", SpecifyFixture.show(expected), null, null));
        Parse rows = new Parse("tr", "", cells1, new Parse("tr", "", cells2, new Parse("tr", "", cells3, null)));
        end.more = new Parse("table", "", rows, null);
    }

    private static String show(Parse parse) {
        if (parse == null) {
            return "null";
        }
        String result = "&lt;" + parse.tag.substring(1, parse.tag.length() - 1) + "&gt;<ul>";
        result = result + SpecifyFixture.showField("leader", parse.leader);
        result = parse.parts != null ? result + SpecifyFixture.show(parse.parts) : result + SpecifyFixture.showField("body", parse.body);
        result = result + SpecifyFixture.showField("trailer", parse.trailer);
        result = result + "</ul>";
        if (parse.more != null) {
            result = result + SpecifyFixture.show(parse.more);
        }
        return result;
    }

    private static String showField(String field, String value) {
        if (value != null && !value.trim().equals("")) {
            return "<li>" + field + ": '" + SpecifyFixture.noTags(value) + "'";
        }
        return "";
    }

    private static String noTags(String value) {
        int index;
        while ((index = value.indexOf("<")) >= 0) {
            value = value.substring(0, index) + "&lt;" + value.substring(index + 1);
        }
        return value;
    }

    public static boolean reportsEqual(Parse actual, Parse expected) {
        if (actual == null) {
            return expected == null;
        }
        if (expected == null) {
            return false;
        }
        SpecifyFixture.massageBodyToTable(actual);
        boolean result = SpecifyFixture.equalTags(actual, expected) && SpecifyFixture.equalStrings(actual.leader, expected.leader) && SpecifyFixture.equalBodies(actual, expected) && SpecifyFixture.equalStrings(actual.trailer, expected.trailer) && SpecifyFixture.reportsEqual(actual.more, expected.more) && SpecifyFixture.reportsEqual(actual.parts, expected.parts);
        return result;
    }

    private static void massageBodyToTable(Parse actual) {
        if (actual.body == null || actual.body.indexOf("<table") < 0) {
            return;
        }
        if (actual.parts == null) {
            try {
                actual.parts = new Parse(actual.body);
            }
            catch (FitParseException fitParseException) {
                // empty catch block
            }
        }
        actual.body = "";
    }

    private static boolean equalBodies(Parse actual, Parse expected) {
        boolean result = SpecifyFixture.equalBodies22(actual, expected);
        if (!result) {
            System.out.println("!SpecifyFixture.equalBodies(\"\n" + actual.body + "\",\"\n" + expected.body + "\")");
        }
        return result;
    }

    private static boolean equalBodies22(Parse actual, Parse expected) {
        int endSpan;
        String expectedBody = SpecifyFixture.canonicalString(expected.body);
        String actualBody = SpecifyFixture.canonicalString(actual.body);
        if (expectedBody.equals("IGNORE")) {
            return true;
        }
        if (actualBody.equals(expectedBody)) {
            return true;
        }
        String stackTrace = "class=\"fit_stacktrace\">";
        int start = expectedBody.indexOf(stackTrace);
        if (start >= 0) {
            String pattern = expectedBody.substring(0, start + stackTrace.length());
            return actual.body.startsWith(pattern);
        }
        start = SpecifyFixture.errorMessage(expectedBody);
        if (start >= 0 && (endSpan = expectedBody.indexOf("</span>", start)) >= 0) {
            String pattern = expectedBody.substring(0, endSpan - 1);
            return actual.body.startsWith(pattern);
        }
        return false;
    }

    private static int errorMessage(String expected) {
        if (expected == null) {
            return -1;
        }
        return expected.indexOf("<span class=\"fit_label\">");
    }

    private static String canonicalString(String s) {
        if (s == null) {
            return "";
        }
        return s.trim().replaceAll("\t", " ").replaceAll("\r", "");
    }

    private static boolean equalTags(Parse p1, Parse p2) {
        return p1.tag.equals(p2.tag);
    }

    private static boolean equalStrings(String actual, String expected) {
        int endSpan;
        boolean result = SpecifyFixture.equalStrings22(actual, expected);
        if (!result && actual != null && expected != null && actual.trim().equals("<br>") && expected.equals("")) {
            return true;
        }
        int start = SpecifyFixture.errorMessage(expected);
        if (start >= 0 && (endSpan = expected.indexOf("</span>", start)) >= 0) {
            String pattern = expected.substring(0, endSpan - 1);
            result = actual.startsWith(pattern);
        }
        if (!result) {
            System.out.println("!SpecifyFixture.equals(\n\"" + SpecifyFixture.showWhiteSpace(actual) + "\",\n\"" + SpecifyFixture.showWhiteSpace(expected) + "\")");
        }
        return result;
    }

    private static String showWhiteSpace(String actual) {
        return actual.replaceAll(" ", "{SPACE}").replaceAll("\t", "{TAB}");
    }

    private static boolean equalStrings22(String actual, String expected) {
        if ((expected = SpecifyFixture.canonicalString(expected)).equals("IGNORE")) {
            return true;
        }
        return SpecifyFixture.canonicalString(actual).equals(expected);
    }
}

