/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser.lookup;

import fitlibrary.exception.parse.BadNumberException;
import fitlibrary.object.DomainObjectCheckTraverse;
import fitlibrary.object.DomainObjectSetUpTraverse;
import fitlibrary.parser.Parser;
import fitlibrary.table.Cell;
import fitlibrary.table.Table;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.TestResults;
import java.beans.PropertyEditor;

public class PrimitiveParser
implements Parser {
    private PropertyEditor editor;
    private Evaluator evaluator;
    private Typed typed;
    private boolean nullOK;

    public PrimitiveParser(Evaluator evaluator, Typed typed, PropertyEditor editor, boolean nullOK) {
        this.evaluator = evaluator;
        this.typed = typed;
        this.editor = editor;
        this.nullOK = nullOK;
    }

    public TypedObject parseTyped(Cell cell, TestResults testResults) throws Exception {
        return this.typed.typedObject(this.parse(cell, testResults));
    }

    private Object parse(Cell cell, TestResults testResults) throws Exception {
        if (cell.hasEmbeddedTable()) {
            return this.parseTable(cell.getEmbeddedTable(), testResults);
        }
        if (this.nullOK && cell.isBlank()) {
            return null;
        }
        try {
            return this.parse(cell.text());
        }
        catch (NumberFormatException e) {
            throw new BadNumberException();
        }
    }

    private Object parse(String text) throws Exception {
        this.editor.setAsText(text);
        return this.editor.getValue();
    }

    private Object parseTable(Table embeddedTable, TestResults testResults) throws Exception {
        Object newInstance = this.typed.newInstance();
        DomainObjectSetUpTraverse setUp = new DomainObjectSetUpTraverse(newInstance);
        setUp.callStartCreatingObjectMethod(newInstance);
        setUp.interpretInnerTable(embeddedTable, this.evaluator, testResults);
        setUp.callEndCreatingObjectMethod(newInstance);
        return newInstance;
    }

    public boolean matches(Cell cell, Object result, TestResults testResults) throws Exception {
        if (cell.hasEmbeddedTable()) {
            return this.matchesTable(cell.getEmbeddedTable(), result, testResults);
        }
        return this.matches(this.parse(cell, testResults), result);
    }

    private boolean matches(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    private boolean matchesTable(Table table, Object result, TestResults testResults) {
        DomainObjectCheckTraverse traverse = new DomainObjectCheckTraverse(result, this.typed);
        return traverse.doesInnerTablePass(table, this.evaluator, testResults);
    }

    public String show(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString();
    }

    public String toString() {
        return "PropertyAdapter[" + this.editor.toString() + "]";
    }

    public Evaluator traverse(TypedObject typedObject) {
        throw new RuntimeException("No Traverse available");
    }
}

