/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser.lookup;

import fitlibrary.collection.array.ArrayParser;
import fitlibrary.collection.list.ListParser;
import fitlibrary.collection.map.MapParser;
import fitlibrary.collection.set.SetParser;
import fitlibrary.object.DomainObjectParser;
import fitlibrary.parser.ByStringParser;
import fitlibrary.parser.DelegateParser;
import fitlibrary.parser.DelegatingParser;
import fitlibrary.parser.FailingDelegateParser;
import fitlibrary.parser.Parser;
import fitlibrary.parser.graphic.GraphicParser;
import fitlibrary.parser.lookup.LookupPrimitiveParser;
import fitlibrary.parser.lookup.ParseDelegation;
import fitlibrary.parser.lookup.ParserFactory;
import fitlibrary.parser.table.TableParser;
import fitlibrary.parser.tagged.TaggedStringParser;
import fitlibrary.parser.tree.TreeParser;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.Typed;
import java.util.HashMap;
import java.util.Map;

public class ParserSelector {
    private Map mapClassToParserFactory = new HashMap(10000, 0.8f);

    public Parser parserFor(Evaluator evaluator, Typed typed, boolean isResult) {
        Class classType = typed.asClass();
        DelegateParser delegate = ParseDelegation.getDelegate(classType);
        if (delegate != null) {
            return delegate.parser(evaluator, typed);
        }
        DomainObjectParser domainObjectParser = new DomainObjectParser(evaluator, typed);
        if (domainObjectParser.hasFinder()) {
            return domainObjectParser;
        }
        ParserFactory parserFactory = (ParserFactory)this.mapClassToParserFactory.get(classType);
        if (parserFactory == null) {
            parserFactory = this.parserFactory(typed, isResult);
            if (parserFactory != null) {
                this.mapClassToParserFactory.put(classType, parserFactory);
            } else {
                if (classType != String.class && classType != Object.class) {
                    return domainObjectParser;
                }
                return new DelegatingParser(new FailingDelegateParser(typed.asClass()), evaluator, typed);
            }
        }
        return parserFactory.parser(evaluator, typed);
    }

    private ParserFactory parserFactory(Typed typed, boolean isResult) {
        Class classType = typed.asClass();
        if (Map.class.isAssignableFrom(classType)) {
            return this.mapParserFactory();
        }
        if (SetParser.applicableType(classType)) {
            return this.setParserFactory();
        }
        if (ArrayParser.applicableType(classType)) {
            return ArrayParser.parserFactory();
        }
        if (ListParser.applicableType(classType)) {
            return this.listParserFactory();
        }
        if (TreeParser.applicableType(classType)) {
            return TreeParser.parserFactory();
        }
        if (TableParser.applicableType(classType)) {
            return TableParser.parserFactory();
        }
        if (GraphicParser.applicableType(classType)) {
            return GraphicParser.parserFactory();
        }
        if (TaggedStringParser.applicableType(classType)) {
            return TaggedStringParser.parserFactory();
        }
        ParserFactory factory = LookupPrimitiveParser.parserFactory(typed);
        if (factory != null) {
            return factory;
        }
        factory = ParseDelegation.delegateClassFactory(typed);
        if (factory != null) {
            return factory;
        }
        if (this.isExtraFactoryFor(typed)) {
            return this.extraFactory();
        }
        if (this.canTreatAsString(classType, typed.hasMethodOrField(), isResult)) {
            return ByStringParser.parserFactory();
        }
        return null;
    }

    protected ParserFactory listParserFactory() {
        return ListParser.parserFactory();
    }

    protected ParserFactory setParserFactory() {
        return SetParser.parserFactory();
    }

    protected ParserFactory mapParserFactory() {
        return MapParser.parserFactory();
    }

    protected boolean isExtraFactoryFor(Typed typed) {
        return false;
    }

    protected ParserFactory extraFactory() {
        return null;
    }

    private boolean canTreatAsString(Class type, boolean hasCaller, boolean isResult) {
        return isResult && hasCaller && type == Object.class;
    }
}

