/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser.lookup;

import fitlibrary.exception.parse.CouldNotParseException;
import fitlibrary.parser.DelegateParser;
import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.ParserFactory;
import fitlibrary.parser.lookup.PrimitiveParser;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.Typed;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LookupPrimitiveParser {
    private static Map classToPropertyEditor = new HashMap();
    static Set nullables = new HashSet();

    public static ParserFactory parserFactory(final Typed typed) {
        final PropertyEditor editor = (PropertyEditor)classToPropertyEditor.get(typed.asClass());
        if (editor != null) {
            return new ParserFactory(){

                public Parser parser(Evaluator evaluator, Typed typed2) {
                    return new PrimitiveParser(evaluator, typed2, editor, nullables.contains(typed.asClass()));
                }
            };
        }
        return null;
    }

    private static void add(Class type) {
        PropertyEditor findEditor = PropertyEditorManager.findEditor(type);
        if (findEditor != null) {
            classToPropertyEditor.put(type, findEditor);
        } else {
            System.out.println("Unable to find a PropertyEditor for: " + type);
        }
    }

    static {
        Class[] classes = new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, String.class};
        for (int i = 0; i < classes.length; ++i) {
            LookupPrimitiveParser.add(classes[i]);
        }
        classToPropertyEditor.put(Integer.class, classToPropertyEditor.get(Integer.TYPE));
        CharPropertyEditor charEditor = new CharPropertyEditor();
        classToPropertyEditor.put(Character.TYPE, charEditor);
        classToPropertyEditor.put(Character.class, charEditor);
        BooleanPropertyEditor boolEditor = new BooleanPropertyEditor();
        classToPropertyEditor.put(Boolean.TYPE, boolEditor);
        classToPropertyEditor.put(Boolean.class, boolEditor);
        classToPropertyEditor.put(Date.class, new DatePropertyEditor());
        classToPropertyEditor.put(Class.class, new ClassPropertyEditor());
        nullables.add(Byte.class);
        nullables.add(Short.class);
        nullables.add(Integer.class);
        nullables.add(Long.class);
        nullables.add(Float.class);
        nullables.add(Double.class);
        nullables.add(Date.class);
    }

    public static class ParseMethodDelegateParser
    extends DelegateParser {
        Method parseMethod;

        public ParseMethodDelegateParser(Class type) {
            super(type);
            try {
                this.parseMethod = type.getMethod("parse", String.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected exception: " + e);
            }
        }

        public Object parse(String text) throws Exception {
            return this.parseMethod.invoke(null, text);
        }
    }

    public static class DatePropertyEditor
    extends PropertyEditorSupport {
        private static final DateFormat dateFormatter = DateFormat.getDateInstance(3);

        public void setAsText(String text) throws IllegalArgumentException {
            try {
                this.setValue(dateFormatter.parse(text));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(text);
            }
        }
    }

    public static class BooleanPropertyEditor
    extends PropertyEditorSupport {
        public void setAsText(String text) throws IllegalArgumentException {
            boolean bool = (text = text.toLowerCase()).equals("true") || text.equals("yes") || text.equals("1") || text.equals("y") || text.equals("+");
            this.setValue(new Boolean(bool));
        }
    }

    public static class CharPropertyEditor
    extends PropertyEditorSupport {
        public void setAsText(String text) throws IllegalArgumentException {
            if ("".equals(text)) {
                this.setValue(new Character(' '));
            } else {
                this.setValue(new Character(text.charAt(0)));
            }
        }
    }

    public static class ClassPropertyEditor
    extends PropertyEditorSupport {
        public void setAsText(String text) throws IllegalArgumentException {
            try {
                this.setValue(Class.forName(text));
            }
            catch (ClassNotFoundException e) {
                throw new CouldNotParseException(Class.class, text);
            }
        }
    }
}

