/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.object;

import fitlibrary.closure.Closure;
import fitlibrary.closure.LookupMethodTarget;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.object.DomainObjectCheckTraverse;
import fitlibrary.object.DomainObjectSetUpTraverse;
import fitlibrary.parser.Parser;
import fitlibrary.ref.EntityReference;
import fitlibrary.table.Cell;
import fitlibrary.table.Table;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.ExtendedCamelCase;
import fitlibrary.utility.TestResults;
import java.lang.reflect.InvocationTargetException;

public class DomainObjectParser
implements Parser {
    public static final String FIND = "find";
    public static final String SHOW = "show";
    private Closure findIntMethod;
    private Closure findStringMethod;
    private Closure showMethod;
    private EntityReference referenceParser;
    private String findExceptionMessage;
    private String showExceptionMethod;
    private String shortClassName;
    protected Evaluator evaluator;
    private Typed typed;

    public DomainObjectParser(Evaluator evaluator, Typed typed) {
        this.evaluator = evaluator;
        this.typed = typed;
        this.shortClassName = typed.simpleClassName();
        this.referenceParser = EntityReference.create(this.shortClassName.toLowerCase());
        this.getFindAndShowMethods();
    }

    public TypedObject parseTyped(Cell cell, TestResults testResults) throws Exception {
        return this.typed.typedObject(this.parse(cell, testResults));
    }

    private Object parse(Cell cell, TestResults testResults) throws Exception {
        if (cell.hasEmbeddedTable()) {
            return this.parseTable(cell.getEmbeddedTable(), testResults);
        }
        return this.find(cell.text());
    }

    private Object find(String text) throws Exception, IllegalAccessException, InvocationTargetException {
        if (this.findIntMethod != null) {
            int index = 0;
            try {
                index = this.referenceParser.getIndex(text);
            }
            catch (FitLibraryException e) {
                return this.callFindStringMethod(text);
            }
            return this.findIntMethod.invoke(new Integer[]{new Integer(index)});
        }
        return this.callFindStringMethod(text);
    }

    private Object callFindStringMethod(String text) throws Exception {
        if (this.findStringMethod != null) {
            return this.findStringMethod.invoke(new String[]{text});
        }
        if ("".equals(text)) {
            return null;
        }
        throw new FitLibraryException(this.findExceptionMessage);
    }

    protected Object parseTable(Table embeddedTable, TestResults testResults) throws Exception {
        TypedObject newInstance = null;
        try {
            newInstance = this.typed.newTypedInstance();
        }
        catch (Exception ex) {
            // empty catch block
        }
        DomainObjectSetUpTraverse setUp = new DomainObjectSetUpTraverse(newInstance, this.typed);
        if (newInstance != null) {
            setUp.setOuterContext(this.evaluator);
            setUp.callStartCreatingObjectMethod(newInstance);
        }
        setUp.interpretInnerTable(embeddedTable, this.evaluator, testResults);
        return setUp.getSystemUnderTest();
    }

    public boolean matches(Cell cell, Object result, TestResults testResults) throws Exception {
        if (result == null) {
            return !cell.hasEmbeddedTable() && cell.isBlank();
        }
        if (cell.hasEmbeddedTable()) {
            return this.matchesTable(cell.getEmbeddedTable(), result, testResults);
        }
        return this.matches(this.parse(cell, testResults), result);
    }

    protected boolean matchesTable(Table table, Object result, TestResults testResults) {
        DomainObjectCheckTraverse traverse = new DomainObjectCheckTraverse(result, this.typed);
        return traverse.doesInnerTablePass(table, this.evaluator, testResults);
    }

    public boolean matches(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    private void getFindAndShowMethods() {
        Class[] intArg = new Class[]{Integer.TYPE};
        Class[] stringArg = new Class[]{String.class};
        Class[] showArg = new Class[]{this.typed.asClass()};
        String findName = ExtendedCamelCase.camel("find " + this.shortClassName);
        String showMethodName = ExtendedCamelCase.camel("show " + this.shortClassName);
        String showMethodSignature = showMethodName + "(" + this.shortClassName + " arg) { }";
        String potentialClasses = LookupMethodTarget.identifiedClassesInOutermostContext(this.evaluator, true);
        this.findExceptionMessage = "EITHER " + this.shortClassName + " is (1) a Value Object. So missing parse method: " + "public static " + this.shortClassName + " parse(String s) { } in class " + this.typed.getClassName() + "; OR (2) an Entity. So missing finder method: " + "public " + this.shortClassName + " find" + this.shortClassName + "(String key) { } in " + potentialClasses;
        this.showExceptionMethod = "Missing show method: public String " + showMethodSignature + " in " + potentialClasses;
        this.findIntMethod = LookupMethodTarget.findFixturingMethod(this.evaluator, findName, intArg);
        this.findStringMethod = LookupMethodTarget.findFixturingMethod(this.evaluator, findName, stringArg);
        this.showMethod = LookupMethodTarget.findFixturingMethod(this.evaluator, showMethodName, showArg);
    }

    public String show(Object result) throws Exception {
        Object[] args = new Object[]{result};
        if (this.showMethod != null) {
            return this.showMethod.invoke(args).toString();
        }
        throw new FitLibraryException(this.showExceptionMethod);
    }

    public Evaluator traverse(TypedObject typedObject) {
        return new DomainObjectCheckTraverse(typedObject);
    }

    public boolean hasFinder() {
        return this.findIntMethod != null || this.findStringMethod != null;
    }
}

