/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.eg.chat;

import fitlibrary.eg.chat.Room;
import fitlibrary.eg.chat.User;
import fitlibrary.exception.FitLibraryException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Chat {
    private List users = new ArrayList();
    private List rooms = new ArrayList();
    private Map roomsMap = new HashMap();
    private Map usersMap = new HashMap();

    public List getUsers() {
        return this.users;
    }

    public void setUsers(List users) {
        Iterator it = users.iterator();
        while (it.hasNext()) {
            this.addUser((User)it.next());
        }
    }

    public List getRooms() {
        return this.rooms;
    }

    public void setRooms(List rooms) {
        Iterator it = rooms.iterator();
        while (it.hasNext()) {
            this.addRoom((Room)it.next());
        }
    }

    public User getUser(String userName) {
        return (User)this.usersMap.get(userName);
    }

    public Room getRoom(String roomName) {
        return (Room)this.roomsMap.get(roomName);
    }

    public boolean connectUser(String userName) {
        this.addUser(new User(userName));
        return true;
    }

    public void disconnectUser(String userName) {
        User user = this.getUser(userName);
        for (Room room : this.roomsMap.values()) {
            room.removeUser(user);
        }
        this.users.remove(user);
        this.usersMap.remove(userName);
    }

    public boolean userCreatesRoom(User user, String roomName) {
        this.addRoom(new Room(roomName));
        return true;
    }

    public boolean userEntersRoom(User user, Room room) {
        room.addUser(user);
        return true;
    }

    public boolean userRemovesRoom(User user, Room room) {
        if (room.isEmpty()) {
            this.rooms.remove(room);
            this.roomsMap.remove(room.getName());
        }
        throw new RuntimeException("Unable to remove room " + room.getName() + " because it's not empty");
    }

    private void addUser(User user) {
        if (this.usersMap.get(user.getName()) != null) {
            throw new FitLibraryException("User already exists");
        }
        this.users.add(user);
        this.usersMap.put(user.getName(), user);
    }

    private void addRoom(Room room) {
        if (this.roomsMap.get(room.getName()) != null) {
            throw new FitLibraryException("Room already exists");
        }
        this.rooms.add(room);
        this.roomsMap.put(room.getName(), room);
    }
}

