/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.collection.set;

import fitlibrary.closure.MethodTarget;
import fitlibrary.collection.CollectionTraverse;
import fitlibrary.exception.table.ExtraCellsException;
import fitlibrary.exception.table.MissingCellsException;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.utility.TestResults;
import java.util.ArrayList;
import java.util.List;

public class SetTraverse
extends CollectionTraverse {
    public SetTraverse(Object sut) {
        super(sut);
    }

    public SetTraverse(Object sut, Object actuals) {
        super(sut, actuals);
    }

    public SetTraverse() {
        super((Object)null);
    }

    public void interpret(Row row, List theActuals, TestResults testResults) throws Exception {
        MethodTarget[] columnBindings;
        if (theActuals.isEmpty()) {
            row.missing(testResults);
            return;
        }
        int rowLength = row.size();
        if (rowLength < (columnBindings = (MethodTarget[])theActuals.get(0)).length) {
            throw new MissingCellsException("SetTraverse");
        }
        if (rowLength > columnBindings.length) {
            throw new ExtraCellsException("SetTraverse");
        }
        List matchingActuals = theActuals;
        for (int column = 0; column < columnBindings.length; ++column) {
            if ((matchingActuals = this.matchOnColumn(row, matchingActuals, column, testResults)).isEmpty()) {
                row.missing(testResults);
                return;
            }
            if (matchingActuals.size() != 1) continue;
            MethodTarget[] theOne = (MethodTarget[])matchingActuals.get(0);
            this.matchRow(row, theOne, testResults);
            theActuals.remove(theOne);
            return;
        }
        if (!matchingActuals.isEmpty()) {
            MethodTarget[] theOne = (MethodTarget[])matchingActuals.get(0);
            this.matchRow(row, theOne, testResults);
            theActuals.remove(theOne);
        }
    }

    private List matchOnColumn(Row row, List theActuals, int column, TestResults testResults) {
        Cell cell = row.cell(column);
        ArrayList<MethodTarget[]> results = new ArrayList<MethodTarget[]>();
        for (MethodTarget[] columnBindings : theActuals) {
            MethodTarget getter = columnBindings[column];
            if (getter == null) {
                if (!cell.isBlank()) continue;
                results.add(columnBindings);
                continue;
            }
            try {
                if (!getter.matches(cell, testResults)) continue;
                results.add(columnBindings);
            }
            catch (Exception e) {}
        }
        return results;
    }
}

