/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.collection.map;

import fitlibrary.collection.map.MapSetUpTraverse;
import fitlibrary.collection.map.MapTraverse;
import fitlibrary.exception.parse.InvalidMapString;
import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.ParserFactory;
import fitlibrary.table.Cell;
import fitlibrary.table.Table;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.NonGenericTyped;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.TestResults;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class MapParser
implements Parser {
    protected final Parser parser;
    protected final Parser showParser;
    protected final Evaluator evaluator;
    protected final Typed typed;
    protected Typed keyTyped = new NonGenericTyped(String.class);
    protected Typed valueTyped = new NonGenericTyped(String.class);

    public static boolean applicableType(Class type) {
        return Map.class.isAssignableFrom(type);
    }

    public MapParser(Evaluator evaluator, Typed typed) {
        this(evaluator, typed, new NonGenericTyped(String.class), new NonGenericTyped(String.class));
    }

    public MapParser(Evaluator evaluator, Typed typed, Typed keyTyped, Typed valueTyped) {
        this.evaluator = evaluator;
        this.typed = typed;
        this.keyTyped = keyTyped;
        this.valueTyped = valueTyped;
        this.parser = Traverse.asTyped(String.class).resultParser(evaluator);
        this.showParser = Traverse.asTyped(Object.class).resultParser(evaluator);
    }

    public TypedObject parseTyped(Cell cell, TestResults testResults) throws Exception {
        return this.typed.typedObject(this.parse(cell, testResults));
    }

    private Object parse(Cell cell, TestResults testResults) throws Exception {
        if (cell.hasEmbeddedTable()) {
            return this.parseTable(cell.getEmbeddedTable(), testResults);
        }
        return this.parse(cell.text(), testResults);
    }

    protected Object parseTable(Table table, TestResults testResults) {
        MapSetUpTraverse setUp = new MapSetUpTraverse(this.keyTyped, this.valueTyped);
        setUp.interpretInnerTable(table, this.evaluator, testResults);
        return setUp.getResults();
    }

    public boolean matches(Cell cell, Object result, TestResults testResults) throws Exception {
        if (result == null) {
            return !cell.hasEmbeddedTable() && cell.isBlank();
        }
        Map map = (Map)result;
        if (cell.hasEmbeddedTable()) {
            return this.tableMatches(cell.getEmbeddedTable(), map, testResults);
        }
        return this.parse(cell, testResults).equals(result);
    }

    protected boolean tableMatches(Table table, Map map, TestResults testResults) {
        MapTraverse traverse = new MapTraverse(map);
        return traverse.doesInnerTablePass(table, this.evaluator, testResults);
    }

    private Object parse(String s, TestResults testResults) throws Exception {
        StringTokenizer t = new StringTokenizer(s, ",");
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        while (t.hasMoreTokens()) {
            String mapString = t.nextToken();
            String[] split = mapString.split("->");
            if (split.length != 2) {
                throw new InvalidMapString(mapString);
            }
            map.put(this.parser.parseTyped(new Cell(split[0]), testResults).getSubject(), this.parser.parseTyped(new Cell(split[1]), testResults).getSubject());
        }
        return map;
    }

    public String show(Object object) throws ArrayIndexOutOfBoundsException, IllegalArgumentException, Exception {
        if (object == null) {
            return "";
        }
        String result = "";
        boolean first = true;
        Map map = (Map)object;
        for (Object key : map.keySet()) {
            String element = this.showParser.show(key) + "->" + map.get(key);
            if (first) {
                first = false;
            } else {
                result = result + ", ";
            }
            result = result + element;
        }
        return result;
    }

    public static ParserFactory parserFactory() {
        return new ParserFactory(){

            public Parser parser(Evaluator evaluator, Typed typed) {
                return new MapParser(evaluator, typed);
            }
        };
    }

    public Evaluator traverse(TypedObject typedObject) {
        return new MapTraverse((Map)typedObject.getSubject());
    }
}

