/*
 * Decompiled with CFR 0.152.
 */
package org.fissore.slf4j;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ConcurrentHashMap;

public class LoggerStats {
    private final ConcurrentHashMap<String, Instant> timestamps = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Long> counts = new ConcurrentHashMap();

    public boolean hasEnoughTimePassed(String caller, long amount, ChronoUnit unit) {
        Instant timestamp = this.timestamps.get(caller);
        if (timestamp == null) {
            return true;
        }
        return timestamp.plus(amount, unit).isBefore(Instant.now());
    }

    public void recordTimestamp(String caller) {
        this.timestamps.put(caller, Instant.now());
    }

    public boolean numberOfCallsEquals(String caller, int amount) {
        Long countedCalls = this.counts.get(caller);
        return countedCalls != null && countedCalls == (long)amount;
    }

    public void recordCall(String caller) {
        this.counts.merge(caller, 1L, (currentCounts, _v) -> currentCounts + 1L);
    }

    public void resetCount(String caller) {
        this.counts.remove(caller);
    }
}

