/*
 * Decompiled with CFR 0.152.
 */
package org.fissore.slf4j;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class LoggerAtLevel {
    private final BiConsumer<String, Throwable> messageThrowableConsumer;
    private Throwable cause;

    public LoggerAtLevel(BiConsumer<String, Throwable> messageThrowableConsumer) {
        this.messageThrowableConsumer = messageThrowableConsumer;
    }

    public LoggerAtLevel withCause(Throwable cause) {
        this.cause = cause;
        return this;
    }

    public void log(String message) {
        this.messageThrowableConsumer.accept(message, this.cause);
    }

    public void log(String format, Object arg) {
        this.logInternal(format, new Object[]{arg});
    }

    public void log(String format, Object arg1, Object arg2) {
        this.logInternal(format, new Object[]{arg1, arg2});
    }

    public void log(String format, Object arg1, Object arg2, Object arg3) {
        this.logInternal(format, new Object[]{arg1, arg2, arg3});
    }

    public void log(String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        this.logInternal(format, new Object[]{arg1, arg2, arg3, arg4});
    }

    public void log(String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        this.logInternal(format, new Object[]{arg1, arg2, arg3, arg4, arg5});
    }

    public void log(String format, Object ... args) {
        this.logInternal(format, args);
    }

    private void logInternal(String format, Object[] args) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])this.toStrings(args));
        this.messageThrowableConsumer.accept(ft.getMessage(), this.cause);
    }

    private Object toString(Object arg) {
        if (arg instanceof Supplier) {
            arg = this.toString(((Supplier)arg).get());
        }
        return arg;
    }

    private Object[] toStrings(Object[] args) {
        if (args == null) {
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.toString(args[i]);
        }
        return args;
    }
}

