/*
 * Decompiled with CFR 0.152.
 */
package com.firestack.laksaj.crypto;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.SecureRandomSpi;

public class LinuxSecureRandom
extends SecureRandomSpi {
    private static final FileInputStream urandom;
    private final DataInputStream dis = new DataInputStream(urandom);

    @Override
    protected void engineSetSeed(byte[] seed) {
    }

    @Override
    protected void engineNextBytes(byte[] bytes) {
        try {
            this.dis.readFully(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected byte[] engineGenerateSeed(int numBytes) {
        byte[] bits = new byte[numBytes];
        this.engineNextBytes(bits);
        return bits;
    }

    static {
        try {
            File file = new File("/dev/urandom");
            urandom = new FileInputStream(file);
            if (urandom.read() == -1) {
                throw new RuntimeException("/dev/urandom not readable, please check your platform");
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

