/*
 * Decompiled with CFR 0.152.
 */
package com.firestack.laksaj.jsonrpc;

import com.firestack.laksaj.blockchain.BlockList;
import com.firestack.laksaj.blockchain.BlockchainInfo;
import com.firestack.laksaj.blockchain.Contract;
import com.firestack.laksaj.blockchain.DsBlock;
import com.firestack.laksaj.blockchain.ShardingStructure;
import com.firestack.laksaj.blockchain.TransactionList;
import com.firestack.laksaj.blockchain.TxBlock;
import com.firestack.laksaj.exception.ZilliqaAPIException;
import com.firestack.laksaj.jsonrpc.Rep;
import com.firestack.laksaj.jsonrpc.Req;
import com.firestack.laksaj.transaction.PendingStatus;
import com.firestack.laksaj.transaction.Transaction;
import com.firestack.laksaj.transaction.TransactionPayload;
import com.firestack.laksaj.transaction.TransactionStatus;
import com.firestack.laksaj.transaction.TxStatus;
import com.firestack.laksaj.utils.Bech32;
import com.google.common.base.Strings;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpProvider {
    private OkHttpClient client = new OkHttpClient();
    private final Gson gson = new Gson();
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private String url;
    private static final Map<Integer, Map<Integer, String>> transactionStatusMap = new HashMap<Integer, Map<Integer, String>>();

    public HttpProvider(String url) {
        this.url = url;
    }

    public HttpProvider(String url, OkHttpClient client) {
        this.url = url;
        this.client = client;
    }

    public Rep<String> getNetworkId() throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetNetworkId").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<String>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<BlockchainInfo> getBlockchainInfo() throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetBlockchainInfo").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<BlockchainInfo>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<ShardingStructure> getShardingStructure() throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetShardingStructure").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<ShardingStructure>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<BlockList> getDSBlockListing(int pageNumber) throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("DSBlockListing").params(new Integer[]{pageNumber}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<BlockList>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<BlockList> getTxBlockListing(int pageNumber) throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("TxBlockListing").params(new Integer[]{pageNumber}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<BlockList>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<String> getNumDSBlocks() throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetNumDSBlocks").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<String>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<Double> getDSBlockRate() throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetDSBlockRate").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<Double>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<BlockList> getDSBlockListing() throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("DSBlockListing").params(new Object[]{1}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<BlockList>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<DsBlock> getDsBlock(String blockNumber) throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetDsBlock").params(new String[]{blockNumber}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<DsBlock>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<TxBlock> getTxBlock(String blockNumber) throws IOException, ZilliqaAPIException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetTxBlock").params(new String[]{blockNumber}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, new TypeToken<Rep<TxBlock>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<String> getNumTxBlocks() throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetNumTxBlocks").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<String>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<Double> getTxBlockRate() throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetTxBlockRate").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<Double>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<DsBlock> getLatestDsBlock() throws IOException, ZilliqaAPIException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetLatestDsBlock").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, new TypeToken<Rep<DsBlock>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<TxBlock> getLatestTxBlock() throws IOException, ZilliqaAPIException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetLatestTxBlock").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, new TypeToken<Rep<TxBlock>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<String> getNumTransactions() throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetNumTransactions").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<String>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<Integer> getTransactionRate() throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetTransactionRate").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<Integer>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<String> getCurrentMiniEpoch() throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetCurrentMiniEpoch").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<String>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<String> getCurrentDSEpoch() throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetCurrentDSEpoch").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<String>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<Integer> getPrevDifficulty() throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetPrevDifficulty").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<Integer>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<Integer> getPrevDSDifficulty() throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetPrevDSDifficulty").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<Integer>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<BalanceResult> getBalance(String address) throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetBalance").params(new String[]{address}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<BalanceResult>>(){}.getType();
        try {
            Rep rep = (Rep)this.gson.fromJson(resultString, type);
            if (null == rep.getResult()) {
                BalanceResult balanceResult = new BalanceResult();
                balanceResult.setBalance("0");
                balanceResult.setNonce("0");
                rep.setResult(balanceResult);
            }
            return rep;
        }
        catch (JsonSyntaxException e) {
            throw new IOException("get wrong result: " + resultString);
        }
    }

    public Rep<BalanceResult> getBalance32(String address) throws Exception {
        return this.getBalance(Bech32.fromBech32Address(address));
    }

    public Rep<ContractResult> getSmartContractCode(String address) throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetSmartContractCode").params(new String[]{address}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<ContractResult>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<List<Contract>> getSmartContracts(String address) throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetSmartContracts").params(new String[]{address}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<List<Contract>>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<String> getContractAddressFromTransactionID(String address) throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetContractAddressFromTransactionID").params(new String[]{address}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<String>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public String getSmartContractState(String address) throws IOException, ZilliqaAPIException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetSmartContractState").params(new String[]{address}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        return resultString;
    }

    public String getSmartContractSubState(List<Object> param) throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetSmartContractSubState").params(param.toArray()).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        return Objects.requireNonNull(response.body()).string();
    }

    public Rep<List<Contract.State>> getSmartContractInit(String address) throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetSmartContractInit").params(new String[]{address}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<List<Contract.State>>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<CreateTxResult> createTransaction(TransactionPayload payload) throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("CreateTransaction").params(new Object[]{payload}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<CreateTxResult>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public List<Transaction> createTransactions(List<Transaction> transactions) throws Exception {
        ArrayList<Req> reqs = new ArrayList<Req>();
        HashMap<String, Transaction> transactionMap = new HashMap<String, Transaction>();
        for (int i = 0; i < transactions.size(); ++i) {
            String index = Integer.toString(i);
            Transaction txn = transactions.get(i);
            transactionMap.put(index, txn);
            TransactionPayload payload = txn.toTransactionPayload();
            Req req = Req.builder().id(index).jsonrpc("2.0").method("CreateTransaction").params(new Object[]{payload}).build();
            reqs.add(req);
        }
        Response response = this.client.newCall(this.buildRequests(reqs)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<List<Rep<CreateTxResult>>>(){}.getType();
        List reps = (List)this.gson.fromJson(resultString, type);
        for (int i = 0; i < reps.size(); ++i) {
            CreateTxResult createTxResult = (CreateTxResult)((Rep)reps.get(i)).getResult();
            if (null == createTxResult) {
                ((Transaction)transactionMap.get(((Rep)reps.get(i)).getId())).setStatus(TxStatus.Rejected);
                ((Transaction)transactionMap.get(((Rep)reps.get(i)).getId())).setInfo(((Rep)reps.get(i)).getError().message);
                continue;
            }
            if (Strings.isNullOrEmpty((String)createTxResult.TranID)) {
                ((Transaction)transactionMap.get(((Rep)reps.get(i)).getId())).setStatus(TxStatus.Rejected);
                ((Transaction)transactionMap.get(((Rep)reps.get(i)).getId())).setInfo(createTxResult.Info);
                continue;
            }
            ((Transaction)transactionMap.get(((Rep)reps.get(i)).getId())).setID(createTxResult.TranID);
        }
        return transactions;
    }

    public Rep<String> getMinimumGasPrice() throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetMinimumGasPrice").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<String>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<TransactionStatus> getTransactionStatus(String hash) throws IOException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetTransactionStatus").params(new String[]{hash}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<TransactionStatus>>(){}.getType());
        if (rep.getResult() == null) {
            throw new IOException("get result error = " + resultString);
        }
        TransactionStatus status = (TransactionStatus)rep.getResult();
        ((TransactionStatus)rep.getResult()).setInfo(transactionStatusMap.get(status.getModificationState()).get(status.getStatus()));
        return rep;
    }

    public Rep<PendingStatus> getPendingTnx(String hash) throws IOException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetPendingTxn").params(new String[]{hash}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<PendingStatus>>(){}.getType());
        if (rep.getResult() == null) {
            throw new IOException("get result error = " + resultString);
        }
        return rep;
    }

    public Rep<Transaction> getTransaction(String hash) throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetTransaction").params(new String[]{hash}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<Transaction>>(){}.getType();
        try {
            Rep rep = (Rep)this.gson.fromJson(resultString, type);
            if (rep.getResult() == null) {
                throw new IOException("get result error = " + resultString);
            }
            return rep;
        }
        catch (JsonSyntaxException e) {
            throw new IOException("get wrong result: " + resultString);
        }
    }

    public Rep<Transaction> getTransaction32(String hash) throws Exception {
        Rep<Transaction> rep = this.getTransaction(hash);
        rep.getResult().setToAddr(Bech32.toBech32Address(rep.getResult().getToAddr()));
        return rep;
    }

    public Rep<TransactionList> getRecentTransactions() throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetRecentTransactions").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<TransactionList>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<List<List<String>>> getTransactionsForTxBlock(String blockNum) throws IOException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetTransactionsForTxBlock").params(new String[]{blockNum}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<List<List<String>>>>(){}.getType());
        if (rep.getResult() == null) {
            Rep<List<List<String>>> res = new Rep<List<List<String>>>();
            res.setJsonrpc("2.0");
            res.setId("1");
            JsonObject jb = (JsonObject)this.gson.fromJson(resultString, JsonObject.class);
            res.setErr(jb.getAsJsonObject("error").get("message").toString());
            return res;
        }
        return rep;
    }

    public Rep<String> getNumTxnsTxEpoch() throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetNumTxnsTxEpoch").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<String>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    public Rep<String> getNumTxnsDSEpoch() throws IOException, ZilliqaAPIException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetNumTxnsDSEpoch").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<String>>(){}.getType());
        if (null == rep.getResult()) {
            Pair pair = this.parseError(resultString);
            throw new ZilliqaAPIException(pair.getMessage(), pair.getCode());
        }
        return rep;
    }

    private Request buildRequest(Req req) throws MalformedURLException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)this.gson.toJson((Object)req));
        return new Request.Builder().post(body).url(new URL(this.url)).build();
    }

    private Request buildRequests(List<Req> reqs) throws MalformedURLException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)this.gson.toJson(reqs));
        return new Request.Builder().post(body).url(new URL(this.url)).build();
    }

    public Pair parseError(String error) {
        JsonObject root = (JsonObject)this.gson.fromJson(error, JsonObject.class);
        JsonObject err = root.getAsJsonObject("error");
        return Pair.builder().code(err.get("code").getAsInt()).message(err.get("message").getAsString()).build();
    }

    static {
        transactionStatusMap.put(0, (Map<Integer, String>)new HashMap<Integer, String>(){
            {
                this.put(0, "Transaction not found");
                this.put(1, "Pending - Dispatched");
            }
        });
        transactionStatusMap.put(1, (Map<Integer, String>)new HashMap<Integer, String>(){
            {
                this.put(2, "Pending - Soft-confirmed (awaiting Tx block generation)");
                this.put(4, "Pending - Nonce is higher than expected");
                this.put(5, "Pending - Microblock gas limit exceeded");
                this.put(6, "Pending - Consensus failure in network");
            }
        });
        transactionStatusMap.put(2, (Map<Integer, String>)new HashMap<Integer, String>(){
            {
                this.put(2, "Confirmed");
                this.put(10, "Rejected - Transaction caused math error");
                this.put(11, "Rejected - Scilla invocation error");
                this.put(12, "Rejected - Contract account initialization error");
                this.put(13, "Rejected - Invalid source account");
                this.put(14, "Rejected - Gas limit higher than shard gas limit");
                this.put(15, "Rejected - Unknown transaction type");
                this.put(16, "Rejected - Transaction sent to wrong shard");
                this.put(17, "Rejected - Contract & source account cross-shard issue");
                this.put(18, "Rejected - Code size exceeded limit");
                this.put(19, "Rejected - Transaction verification failed");
                this.put(20, "Rejected - Gas limit too low");
                this.put(21, "Rejected - Insufficient balance");
                this.put(22, "Rejected - Insufficient gas to invoke Scilla checker");
                this.put(23, "Rejected - Duplicate transaction exists");
                this.put(24, "Rejected - Transaction with higher gas price exists");
                this.put(25, "Rejected - Invalid destination address");
                this.put(26, "Rejected - Failed to add contract account to state");
                this.put(27, "Rejected - Nonce is lower than expected");
                this.put(255, "Rejected - Internal error");
            }
        });
    }

    public static class Pair {
        private String message;
        private int code;

        Pair(String message, int code) {
            this.message = message;
            this.code = code;
        }

        public static PairBuilder builder() {
            return new PairBuilder();
        }

        public String getMessage() {
            return this.message;
        }

        public int getCode() {
            return this.code;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            return this.getCode() == other.getCode();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Pair;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            result = result * 59 + this.getCode();
            return result;
        }

        public String toString() {
            return "HttpProvider.Pair(message=" + this.getMessage() + ", code=" + this.getCode() + ")";
        }

        public static class PairBuilder {
            private String message;
            private int code;

            PairBuilder() {
            }

            public PairBuilder message(String message) {
                this.message = message;
                return this;
            }

            public PairBuilder code(int code) {
                this.code = code;
                return this;
            }

            public Pair build() {
                return new Pair(this.message, this.code);
            }

            public String toString() {
                return "HttpProvider.Pair.PairBuilder(message=" + this.message + ", code=" + this.code + ")";
            }
        }
    }

    public static class CreateTxError {
        private Integer code;
        private Object data;
        private String message;

        public Integer getCode() {
            return this.code;
        }

        public Object getData() {
            return this.data;
        }

        public String getMessage() {
            return this.message;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public void setData(Object data2) {
            this.data = data2;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateTxError)) {
                return false;
            }
            CreateTxError other = (CreateTxError)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$code = this.getCode();
            Integer other$code = other.getCode();
            if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
                return false;
            }
            Object this$data = this.getData();
            Object other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CreateTxError;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
            Object $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public String toString() {
            return "HttpProvider.CreateTxError(code=" + this.getCode() + ", data=" + this.getData() + ", message=" + this.getMessage() + ")";
        }
    }

    public static class CreateTxResult {
        private String Info;
        private String TranID;
        private String ContractAddress;

        public String toString() {
            return "CreateTxResult{Info='" + this.Info + '\'' + ", TranID='" + this.TranID + '\'' + ", ContractAddress='" + this.ContractAddress + '\'' + '}';
        }

        public String getInfo() {
            return this.Info;
        }

        public String getTranID() {
            return this.TranID;
        }

        public String getContractAddress() {
            return this.ContractAddress;
        }

        public void setInfo(String Info) {
            this.Info = Info;
        }

        public void setTranID(String TranID) {
            this.TranID = TranID;
        }

        public void setContractAddress(String ContractAddress) {
            this.ContractAddress = ContractAddress;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateTxResult)) {
                return false;
            }
            CreateTxResult other = (CreateTxResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$Info = this.getInfo();
            String other$Info = other.getInfo();
            if (this$Info == null ? other$Info != null : !this$Info.equals(other$Info)) {
                return false;
            }
            String this$TranID = this.getTranID();
            String other$TranID = other.getTranID();
            if (this$TranID == null ? other$TranID != null : !this$TranID.equals(other$TranID)) {
                return false;
            }
            String this$ContractAddress = this.getContractAddress();
            String other$ContractAddress = other.getContractAddress();
            return !(this$ContractAddress == null ? other$ContractAddress != null : !this$ContractAddress.equals(other$ContractAddress));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CreateTxResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $Info = this.getInfo();
            result = result * 59 + ($Info == null ? 43 : $Info.hashCode());
            String $TranID = this.getTranID();
            result = result * 59 + ($TranID == null ? 43 : $TranID.hashCode());
            String $ContractAddress = this.getContractAddress();
            result = result * 59 + ($ContractAddress == null ? 43 : $ContractAddress.hashCode());
            return result;
        }
    }

    public static class ContractResult {
        private String code;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContractResult)) {
                return false;
            }
            ContractResult other = (ContractResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            return !(this$code == null ? other$code != null : !this$code.equals(other$code));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ContractResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            return result;
        }

        public String toString() {
            return "HttpProvider.ContractResult(code=" + this.getCode() + ")";
        }
    }

    public static class BalanceResult {
        private String balance;
        private String nonce;

        public String getBalance() {
            return this.balance;
        }

        public String getNonce() {
            return this.nonce;
        }

        public void setBalance(String balance) {
            this.balance = balance;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BalanceResult)) {
                return false;
            }
            BalanceResult other = (BalanceResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$balance = this.getBalance();
            String other$balance = other.getBalance();
            if (this$balance == null ? other$balance != null : !this$balance.equals(other$balance)) {
                return false;
            }
            String this$nonce = this.getNonce();
            String other$nonce = other.getNonce();
            return !(this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BalanceResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $balance = this.getBalance();
            result = result * 59 + ($balance == null ? 43 : $balance.hashCode());
            String $nonce = this.getNonce();
            result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
            return result;
        }

        public String toString() {
            return "HttpProvider.BalanceResult(balance=" + this.getBalance() + ", nonce=" + this.getNonce() + ")";
        }
    }
}

