/*
 * Decompiled with CFR 0.152.
 */
package com.firestack.laksaj.crypto;

import com.firestack.laksaj.crypto.KDFType;
import com.firestack.laksaj.crypto.KeyStore;
import com.firestack.laksaj.crypto.Schnorr;
import com.firestack.laksaj.utils.ByteUtil;
import com.firestack.laksaj.utils.HashUtil;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.web3j.crypto.ECKeyPair;
import org.web3j.utils.Numeric;

public class KeyTools {
    public static final ECDomainParameters CURVE;
    private static final X9ECParameters CURVE_PARAMS;
    private static final KeyStore keystore;
    private static final Pattern pattern;

    public static String generatePrivateKey() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        ECKeyPair keys = Schnorr.generateKeyPair();
        return Numeric.toHexStringNoPrefixZeroPadded((BigInteger)keys.getPrivateKey(), (int)64);
    }

    @Deprecated
    public static ECKeyPair generateKeyPair() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        ECKeyPair keyPair;
        while ((keyPair = Schnorr.generateKeyPair()).getPrivateKey().toString(16).length() != 64) {
        }
        return keyPair;
    }

    public static String getAddressFromPrivateKey(String privateKey) {
        String publicKey = KeyTools.getPublicKeyFromPrivateKey(privateKey, true);
        return KeyTools.getAddressFromPublicKey(publicKey);
    }

    public static boolean isByteString(String address) {
        System.out.println(address);
        Matcher matcher = pattern.matcher(address);
        while (matcher.find()) {
            System.out.println(matcher.group());
            System.out.print("start:" + matcher.start());
            System.out.println(" end:" + matcher.end());
        }
        return true;
    }

    public static String getPublicKeyFromPrivateKey(String privateKey, boolean compressed) {
        byte[] pk = ByteUtil.hexStringToByteArray(privateKey);
        BigInteger bigInteger = new BigInteger(1, pk);
        ECPoint point = KeyTools.getPublicPointFromPrivate(bigInteger);
        return ByteUtil.byteArrayToHexString(point.getEncoded(compressed));
    }

    public static String getAddressFromPublicKey(String publicKey) {
        byte[] address = KeyTools.getAddressFromPublicKey(Numeric.hexStringToByteArray((String)publicKey));
        return ByteUtil.byteArrayToHexString(address).substring(24);
    }

    public static byte[] getAddressFromPublicKey(byte[] publicKey) {
        return HashUtil.sha256(publicKey);
    }

    public static byte[] generateRandomBytes(int size) {
        byte[] bytes = new byte[size];
        new SecureRandom().nextBytes(bytes);
        return bytes;
    }

    private static ECPoint getPublicPointFromPrivate(BigInteger privateKeyPoint) {
        if (privateKeyPoint.bitLength() > CURVE.getN().bitLength()) {
            privateKeyPoint = privateKeyPoint.mod(CURVE.getN());
        }
        return new FixedPointCombMultiplier().multiply(CURVE.getG(), privateKeyPoint);
    }

    public static String decryptPrivateKey(String file, String passphrase) throws Exception {
        return keystore.decryptPrivateKey(file, passphrase);
    }

    public static String encryptPrivateKey(String privateKey, String passphrase, KDFType type) throws Exception {
        return keystore.encryptPrivateKey(privateKey, passphrase, type);
    }

    static {
        CURVE_PARAMS = CustomNamedCurves.getByName((String)"secp256k1");
        keystore = KeyStore.defaultKeyStore();
        pattern = Pattern.compile("^(0x)?[0-9a-f]");
        CURVE = new ECDomainParameters(CURVE_PARAMS.getCurve(), CURVE_PARAMS.getG(), CURVE_PARAMS.getN(), CURVE_PARAMS.getH());
    }
}

