/*
 * Decompiled with CFR 0.152.
 */
package com.firestack.laksaj.crypto;

import com.firestack.laksaj.crypto.CustomSecureRandom;
import com.firestack.laksaj.crypto.Signature;
import com.firestack.laksaj.utils.HashUtil;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.prng.SP800SecureRandomBuilder;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECPoint;
import org.web3j.crypto.ECKeyPair;

public class Schnorr {
    private static final ECNamedCurveParameterSpec secp256k1;
    private static final int PUBKEY_COMPRESSED_SIZE_BYTES = 33;
    private static final byte[] ALG;
    private static final int ENT_BITS = 256;

    static ECKeyPair generateKeyPair() throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", "BC");
        keyPairGenerator.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec("secp256k1"));
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        BCECPrivateKey privateKey = (BCECPrivateKey)keyPair.getPrivate();
        BCECPublicKey publicKey = (BCECPublicKey)keyPair.getPublic();
        return new ECKeyPair(privateKey.getD(), new BigInteger(1, publicKey.getQ().getEncoded(true)));
    }

    public static Signature sign(ECKeyPair kp, byte[] message) {
        SecureRandom drbg = Schnorr.getDRBG(message);
        int len = secp256k1.getN().bitLength() / 8;
        byte[] bytes = new byte[len];
        drbg.nextBytes(bytes);
        Signature signature = null;
        while (signature == null) {
            BigInteger k = new BigInteger(1, bytes);
            signature = Schnorr.trySign(kp, message, k);
        }
        return signature;
    }

    public static Signature trySign(ECKeyPair kp, byte[] msg, BigInteger k) throws IllegalArgumentException {
        BigInteger n = secp256k1.getN();
        BigInteger privateKey = kp.getPrivateKey();
        ECPoint publicKey = secp256k1.getCurve().decodePoint(kp.getPublicKey().toByteArray());
        if (privateKey.equals(BigInteger.ZERO)) {
            throw new IllegalArgumentException("Private key must be >= 0");
        }
        if (privateKey.compareTo(n) >= 0) {
            throw new IllegalArgumentException("Private key cannot be greater than curve order");
        }
        ECPoint Q = secp256k1.getG().multiply(k);
        BigInteger r = Schnorr.hash(Q, publicKey, msg).mod(secp256k1.getN());
        if (r.equals(BigInteger.ZERO)) {
            return null;
        }
        BigInteger s = r.multiply(privateKey).mod(n);
        if ((s = k.subtract(s).mod(n)).equals(BigInteger.ZERO)) {
            return null;
        }
        return Signature.builder().r(r).s(s).build();
    }

    private static BigInteger hash(ECPoint q, ECPoint pubKey, byte[] msg) {
        int totalLength = 66 + msg.length;
        byte[] qCompressed = q.getEncoded(true);
        byte[] pubKeyCompressed = pubKey.getEncoded(true);
        byte[] hashInput = new byte[totalLength];
        Arrays.fill(hashInput, (byte)0);
        System.arraycopy(qCompressed, 0, hashInput, 0, 33);
        System.arraycopy(pubKeyCompressed, 0, hashInput, 33, 33);
        System.arraycopy(msg, 0, hashInput, 66, msg.length);
        byte[] hash = HashUtil.sha256(hashInput);
        return new BigInteger(1, hash);
    }

    static boolean verify(byte[] msg, Signature sig, ECPoint publicKey) throws IllegalArgumentException {
        ECPoint r;
        if (sig.getR().equals(BigInteger.ZERO) || sig.getS().equals(BigInteger.ZERO)) {
            throw new IllegalArgumentException("Invalid R or S value: cannot be zero.");
        }
        if (sig.getR().signum() == -1 || sig.getS().signum() == -1) {
            throw new IllegalArgumentException("Invalid R or S value: cannot be negative.");
        }
        if (!publicKey.getCurve().equals(secp256k1.getCurve())) {
            throw new IllegalArgumentException("The public key must be a point on secp256k1.");
        }
        if (!publicKey.isValid()) {
            throw new IllegalArgumentException("Invalid public key.");
        }
        ECPoint l = publicKey.multiply(sig.getR());
        ECPoint Q = l.add(r = secp256k1.getG().multiply(sig.getS()));
        if (Q.isInfinity() || !Q.isValid()) {
            throw new IllegalArgumentException("Invalid intermediate point.");
        }
        BigInteger r1 = Schnorr.hash(Q, publicKey, msg).mod(secp256k1.getN());
        if (r1.equals(BigInteger.ZERO)) {
            throw new IllegalArgumentException("Invalid hash.");
        }
        return r1.equals(sig.getR());
    }

    private static SecureRandom getDRBG(byte[] message) {
        SHA256Digest sha256 = new SHA256Digest();
        HMac hMac = new HMac((Digest)sha256);
        return new SP800SecureRandomBuilder((SecureRandom)new CustomSecureRandom(), false).setEntropyBitsRequired(256).setPersonalizationString(ALG).buildHMAC((Mac)hMac, message, true);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        secp256k1 = ECNamedCurveTable.getParameterSpec((String)"secp256k1");
        ALG = "Schnorr+SHA256 ".getBytes();
    }
}

