/*
 * Decompiled with CFR 0.152.
 */
package com.firestack.laksaj.transaction;

import com.firestack.laksaj.jsonrpc.HttpProvider;
import com.firestack.laksaj.transaction.Transaction;
import com.firestack.laksaj.transaction.TransactionPayload;
import com.firestack.laksaj.transaction.TxParams;
import com.firestack.laksaj.transaction.TxStatus;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;

public class TransactionFactory {
    public static Transaction buildTransaction(TxParams params, HttpProvider provider, TxStatus status) {
        return Transaction.builder().ID(params.getID()).version(params.getVersion()).nonce(params.getNonce()).amount(params.getAmount()).gasPrice(params.getGasPrice()).gasLimit(params.getGasLimit()).signature(params.getSignature()).receipt(params.getReceipt()).senderPubKey(params.getSenderPubKey()).toAddr(params.getToAddr()).code(params.getCode()).data(params.getData()).provider(provider).status(status).build();
    }

    public static HttpProvider.CreateTxResult createTransaction(Transaction signedTx) throws Exception {
        return signedTx.getProvider().createTransaction(signedTx.toTransactionPayload()).getResult();
    }

    public static List<TransactionPayload> toPayloads(List<Transaction> transactions) throws Exception {
        ArrayList<TransactionPayload> payloads = new ArrayList<TransactionPayload>();
        for (int i = 0; i < transactions.size(); ++i) {
            payloads.add(transactions.get(i).toTransactionPayload());
        }
        return payloads;
    }

    public static List<Transaction> batchConfirm(List<Transaction> transactions, int maxAttempts, int interval) throws InterruptedException {
        int i;
        for (i = 0; i < transactions.size(); ++i) {
            Transaction transaction = transactions.get(i);
            if (TxStatus.Rejected == transaction.getStatus()) continue;
            transaction.setStatus(TxStatus.Pending);
        }
        for (i = 0; i < maxAttempts; ++i) {
            Thread.sleep(Duration.of(interval, ChronoUnit.SECONDS).toMillis());
            for (int j = 0; j < transactions.size(); ++j) {
                Transaction transaction = transactions.get(j);
                if (TxStatus.Pending != transaction.getStatus() || !transaction.trackTx(transaction.getID())) continue;
                transaction.setStatus(TxStatus.Confirmed);
            }
        }
        for (int j = 0; j < transactions.size(); ++j) {
            Transaction transaction = transactions.get(j);
            if (TxStatus.Pending != transaction.getStatus()) continue;
            transaction.setStatus(TxStatus.Rejected);
            transaction.setInfo("cannot track after time limit");
        }
        return transactions;
    }
}

