/*
 * Decompiled with CFR 0.152.
 */
package com.firestack.laksaj.contract;

import com.firestack.laksaj.account.Account;
import com.firestack.laksaj.account.Wallet;
import com.firestack.laksaj.blockchain.Contract;
import com.firestack.laksaj.contract.CallParams;
import com.firestack.laksaj.contract.ContractFactory;
import com.firestack.laksaj.contract.ContractStatus;
import com.firestack.laksaj.contract.DeployParams;
import com.firestack.laksaj.contract.Value;
import com.firestack.laksaj.jsonrpc.HttpProvider;
import com.firestack.laksaj.transaction.Transaction;
import com.firestack.laksaj.transaction.TxStatus;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javafx.util.Pair;

public class Contract {
    public static String NIL_ADDRESS = "0x0000000000000000000000000000000000000000";
    private ContractFactory contractFactory;
    private Value[] init;
    private String abi;
    private List<Contract.State> state;
    private String address;
    private String code;
    private ContractStatus contractStatus;
    private Wallet signer;
    private HttpProvider provider;

    public Contract(ContractFactory factory, String code, String abi, String address, Value[] init, List<Contract.State> state) throws Exception {
        this.contractFactory = factory;
        this.provider = factory.getProvider();
        this.signer = factory.getSigner();
        if (null != address && !address.isEmpty()) {
            this.abi = abi;
            this.address = Account.normaliseAddress(address);
            this.init = init;
            this.state = state;
            this.code = code;
            this.contractStatus = ContractStatus.Deployed;
        } else {
            this.abi = abi;
            this.code = code;
            this.init = init;
            this.contractStatus = ContractStatus.Initialised;
        }
    }

    public Pair<Transaction, Contract> deploy(DeployParams params, int attempts, int interval) throws Exception {
        if (null == this.code || this.code.isEmpty() || null == this.init || this.init.length == 0) {
            throw new IllegalArgumentException("Cannot deploy without code or initialisation parameters.");
        }
        Gson gson = new Gson();
        Transaction transaction = Transaction.builder().ID(params.getID()).version(params.getVersion()).nonce(params.getNonce()).gasPrice(params.getGasPrice()).gasLimit(params.getGasLimit()).senderPubKey(params.getSenderPubKey()).toAddr(NIL_ADDRESS).amount("0").code(this.code.replace("/\\", "")).data(gson.toJson((Object)this.init).replace("/\\", "")).provider(this.provider).build();
        if ((transaction = this.prepareTx(transaction, attempts, interval)).isRejected()) {
            this.contractStatus = ContractStatus.Rejected;
            Pair pair = new Pair((Object)transaction, (Object)this);
            return pair;
        }
        this.contractStatus = ContractStatus.Deployed;
        this.address = ContractFactory.getAddressForContract(transaction);
        Pair pair = new Pair((Object)transaction, (Object)this);
        return pair;
    }

    public HttpProvider.CreateTxResult deployWithoutConfirm(DeployParams params) throws Exception {
        if (null == this.code || this.code.isEmpty() || null == this.init || this.init.length == 0) {
            throw new IllegalArgumentException("Cannot deploy without code or initialisation parameters.");
        }
        Gson gson = new Gson();
        Transaction transaction = Transaction.builder().ID(params.getID()).version(params.getVersion()).nonce(params.getNonce()).gasPrice(params.getGasPrice()).gasLimit(params.getGasLimit()).senderPubKey(params.getSenderPubKey()).toAddr(NIL_ADDRESS).amount("0").code(this.code.replace("/\\", "")).data(gson.toJson((Object)this.init).replace("/\\", "")).provider(this.provider).build();
        return this.prepareTx(transaction);
    }

    public Transaction call(String transition, Value[] args, CallParams params, int attempts, int interval) throws Exception {
        if (null == this.address || this.address.isEmpty()) {
            throw new IllegalArgumentException("Contract has not been deployed!");
        }
        Gson gson = new Gson();
        Transaction transaction = Transaction.builder().ID(params.getID()).version(params.getVersion()).nonce(params.getNonce()).amount(params.getAmount()).gasPrice(params.getGasPrice()).gasLimit(params.getGasLimit()).senderPubKey(params.getSenderPubKey()).data(gson.toJson((Object)data.builder()._tag(transition).params(args).build())).provider(this.provider).toAddr(this.address).code(this.code.replace("/\\", "")).build();
        return this.prepareTx(transaction, attempts, interval);
    }

    public HttpProvider.CreateTxResult prepareTx(Transaction tx) throws Exception {
        tx = this.signer.sign(tx);
        HttpProvider.CreateTxResult createTxResult = this.provider.createTransaction(tx.toTransactionPayload()).getResult();
        return createTxResult;
    }

    public Transaction prepareTx(Transaction tx, int attempts, int interval) throws Exception {
        tx = this.signer.sign(tx);
        try {
            HttpProvider.CreateTxResult createTxResult = this.provider.createTransaction(tx.toTransactionPayload()).getResult();
            tx.confirm(createTxResult.getTranID(), attempts, interval);
        }
        catch (IOException e) {
            e.printStackTrace();
            tx.setStatus(TxStatus.Rejected);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return tx;
    }

    public boolean isInitialised() {
        return ContractStatus.Initialised.equals((Object)this.contractStatus);
    }

    public boolean isDeployed() {
        return ContractStatus.Deployed.equals((Object)this.contractStatus);
    }

    public boolean isRejected() {
        return ContractStatus.Rejected.equals((Object)this.contractStatus);
    }

    public ContractFactory getContractFactory() {
        return this.contractFactory;
    }

    public Value[] getInit() {
        return this.init;
    }

    public String getAbi() {
        return this.abi;
    }

    public List<Contract.State> getState() {
        return this.state;
    }

    public String getAddress() {
        return this.address;
    }

    public String getCode() {
        return this.code;
    }

    public ContractStatus getContractStatus() {
        return this.contractStatus;
    }

    public Wallet getSigner() {
        return this.signer;
    }

    public HttpProvider getProvider() {
        return this.provider;
    }

    public void setContractFactory(ContractFactory contractFactory) {
        this.contractFactory = contractFactory;
    }

    public void setInit(Value[] init) {
        this.init = init;
    }

    public void setAbi(String abi) {
        this.abi = abi;
    }

    public void setState(List<Contract.State> state) {
        this.state = state;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setContractStatus(ContractStatus contractStatus) {
        this.contractStatus = contractStatus;
    }

    public void setSigner(Wallet signer) {
        this.signer = signer;
    }

    public void setProvider(HttpProvider provider) {
        this.provider = provider;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Contract)) {
            return false;
        }
        Contract other = (Contract)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ContractFactory this$contractFactory = this.getContractFactory();
        ContractFactory other$contractFactory = other.getContractFactory();
        if (this$contractFactory == null ? other$contractFactory != null : !((Object)this$contractFactory).equals(other$contractFactory)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInit(), other.getInit())) {
            return false;
        }
        String this$abi = this.getAbi();
        String other$abi = other.getAbi();
        if (this$abi == null ? other$abi != null : !this$abi.equals(other$abi)) {
            return false;
        }
        List<Contract.State> this$state = this.getState();
        List<Contract.State> other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        ContractStatus this$contractStatus = this.getContractStatus();
        ContractStatus other$contractStatus = other.getContractStatus();
        if (this$contractStatus == null ? other$contractStatus != null : !((Object)((Object)this$contractStatus)).equals((Object)other$contractStatus)) {
            return false;
        }
        Wallet this$signer = this.getSigner();
        Wallet other$signer = other.getSigner();
        if (this$signer == null ? other$signer != null : !this$signer.equals(other$signer)) {
            return false;
        }
        HttpProvider this$provider = this.getProvider();
        HttpProvider other$provider = other.getProvider();
        return !(this$provider == null ? other$provider != null : !this$provider.equals(other$provider));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Contract;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContractFactory $contractFactory = this.getContractFactory();
        result = result * 59 + ($contractFactory == null ? 43 : ((Object)$contractFactory).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getInit());
        String $abi = this.getAbi();
        result = result * 59 + ($abi == null ? 43 : $abi.hashCode());
        List<Contract.State> $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        ContractStatus $contractStatus = this.getContractStatus();
        result = result * 59 + ($contractStatus == null ? 43 : ((Object)((Object)$contractStatus)).hashCode());
        Wallet $signer = this.getSigner();
        result = result * 59 + ($signer == null ? 43 : $signer.hashCode());
        HttpProvider $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        return result;
    }

    public String toString() {
        return "Contract(contractFactory=" + this.getContractFactory() + ", init=" + Arrays.deepToString(this.getInit()) + ", abi=" + this.getAbi() + ", state=" + this.getState() + ", address=" + this.getAddress() + ", code=" + this.getCode() + ", contractStatus=" + (Object)((Object)this.getContractStatus()) + ", signer=" + this.getSigner() + ", provider=" + this.getProvider() + ")";
    }

    private static class data {
        private String _tag;
        private Value[] params;

        data(String _tag, Value[] params) {
            this._tag = _tag;
            this.params = params;
        }

        public static dataBuilder builder() {
            return new dataBuilder();
        }

        public String get_tag() {
            return this._tag;
        }

        public Value[] getParams() {
            return this.params;
        }

        public void set_tag(String _tag) {
            this._tag = _tag;
        }

        public void setParams(Value[] params) {
            this.params = params;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof data)) {
                return false;
            }
            data other = (data)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$_tag = this.get_tag();
            String other$_tag = other.get_tag();
            if (this$_tag == null ? other$_tag != null : !this$_tag.equals(other$_tag)) {
                return false;
            }
            return Arrays.deepEquals(this.getParams(), other.getParams());
        }

        protected boolean canEqual(Object other) {
            return other instanceof data;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $_tag = this.get_tag();
            result = result * 59 + ($_tag == null ? 43 : $_tag.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getParams());
            return result;
        }

        public String toString() {
            return "Contract.data(_tag=" + this.get_tag() + ", params=" + Arrays.deepToString(this.getParams()) + ")";
        }

        public static class dataBuilder {
            private String _tag;
            private Value[] params;

            dataBuilder() {
            }

            public dataBuilder _tag(String _tag) {
                this._tag = _tag;
                return this;
            }

            public dataBuilder params(Value[] params) {
                this.params = params;
                return this;
            }

            public data build() {
                return new data(this._tag, this.params);
            }

            public String toString() {
                return "Contract.data.dataBuilder(_tag=" + this._tag + ", params=" + Arrays.deepToString(this.params) + ")";
            }
        }
    }
}

