/*
 * Decompiled with CFR 0.152.
 */
package com.firestack.laksaj.crypto;

import java.math.BigInteger;
import org.spongycastle.util.encoders.Hex;

public class Signature {
    private BigInteger r;
    private BigInteger s;

    public String toString() {
        String rHex = Hex.toHexString((byte[])this.r.toByteArray());
        while (rHex.length() < 64) {
            rHex = "0" + rHex;
        }
        while (rHex.length() > 64 && rHex.charAt(0) == '0') {
            rHex = rHex.substring(1);
        }
        String sHex = Hex.toHexString((byte[])this.s.toByteArray());
        while (sHex.length() < 64) {
            sHex = "0" + sHex;
        }
        while (sHex.length() > 64 && sHex.charAt(0) == '0') {
            sHex = sHex.substring(1);
        }
        return rHex + sHex;
    }

    public boolean isNil() {
        return this.r.equals(BigInteger.ZERO) && this.s.equals(BigInteger.ZERO);
    }

    Signature(BigInteger r, BigInteger s) {
        this.r = r;
        this.s = s;
    }

    public static SignatureBuilder builder() {
        return new SignatureBuilder();
    }

    public BigInteger getR() {
        return this.r;
    }

    public BigInteger getS() {
        return this.s;
    }

    public void setR(BigInteger r) {
        this.r = r;
    }

    public void setS(BigInteger s) {
        this.s = s;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Signature)) {
            return false;
        }
        Signature other = (Signature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$r = this.getR();
        BigInteger other$r = other.getR();
        if (this$r == null ? other$r != null : !((Object)this$r).equals(other$r)) {
            return false;
        }
        BigInteger this$s = this.getS();
        BigInteger other$s = other.getS();
        return !(this$s == null ? other$s != null : !((Object)this$s).equals(other$s));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Signature;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $r = this.getR();
        result = result * 59 + ($r == null ? 43 : ((Object)$r).hashCode());
        BigInteger $s = this.getS();
        result = result * 59 + ($s == null ? 43 : ((Object)$s).hashCode());
        return result;
    }

    public static class SignatureBuilder {
        private BigInteger r;
        private BigInteger s;

        SignatureBuilder() {
        }

        public SignatureBuilder r(BigInteger r) {
            this.r = r;
            return this;
        }

        public SignatureBuilder s(BigInteger s) {
            this.s = s;
            return this;
        }

        public Signature build() {
            return new Signature(this.r, this.s);
        }

        public String toString() {
            return "Signature.SignatureBuilder(r=" + this.r + ", s=" + this.s + ")";
        }
    }
}

