/*
 * Decompiled with CFR 0.152.
 */
package com.firestack.laksaj.blockchain;

import com.firestack.laksaj.blockchain.BlockShort;
import java.util.Arrays;

public class BlockList {
    private BlockShort[] data;
    private int maxPages;

    BlockList(BlockShort[] data2, int maxPages) {
        this.data = data2;
        this.maxPages = maxPages;
    }

    public static BlockListBuilder builder() {
        return new BlockListBuilder();
    }

    public BlockShort[] getData() {
        return this.data;
    }

    public int getMaxPages() {
        return this.maxPages;
    }

    public void setData(BlockShort[] data2) {
        this.data = data2;
    }

    public void setMaxPages(int maxPages) {
        this.maxPages = maxPages;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockList)) {
            return false;
        }
        BlockList other = (BlockList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getData(), other.getData())) {
            return false;
        }
        return this.getMaxPages() == other.getMaxPages();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getData());
        result = result * 59 + this.getMaxPages();
        return result;
    }

    public String toString() {
        return "BlockList(data=" + Arrays.deepToString(this.getData()) + ", maxPages=" + this.getMaxPages() + ")";
    }

    public static class BlockListBuilder {
        private BlockShort[] data;
        private int maxPages;

        BlockListBuilder() {
        }

        public BlockListBuilder data(BlockShort[] data2) {
            this.data = data2;
            return this;
        }

        public BlockListBuilder maxPages(int maxPages) {
            this.maxPages = maxPages;
            return this;
        }

        public BlockList build() {
            return new BlockList(this.data, this.maxPages);
        }

        public String toString() {
            return "BlockList.BlockListBuilder(data=" + Arrays.deepToString(this.data) + ", maxPages=" + this.maxPages + ")";
        }
    }
}

