/*
 * Decompiled with CFR 0.152.
 */
package com.firestack.laksaj.utils;

import com.firestack.laksaj.account.Account;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Validation {
    public static boolean isByteString(String str, int len) {
        Pattern pattern = Pattern.compile("^(0x)?[0-9a-fA-F]{" + len + "}");
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    public static boolean isAddress(String address) {
        return Validation.isByteString(address, 40);
    }

    public static boolean isPublicKey(String publicKey) {
        return Validation.isByteString(publicKey, 66);
    }

    public static boolean isPrivateKey(String privateKey) {
        return Validation.isByteString(privateKey, 64);
    }

    public static boolean isSignature(String signature) {
        return Validation.isByteString(signature, 128);
    }

    public static boolean isValidChecksumAddress(String address) {
        return Validation.isAddress(address.replace("0x", "")) && Account.toCheckSumAddress(address).equals(address);
    }

    public static String intToHex(int value, int size) {
        int i;
        String hexVal = Integer.toHexString(value);
        char[] hexRep = new char[hexVal.length()];
        for (int i2 = 0; i2 < hexVal.length(); ++i2) {
            hexRep[i2] = hexVal.charAt(i2);
        }
        ArrayList<Character> hex = new ArrayList<Character>();
        for (i = 0; i < size - hexVal.length(); ++i) {
            hex.add(Character.valueOf('0'));
        }
        for (i = 0; i < hexVal.length(); ++i) {
            hex.add(Character.valueOf(hexRep[i]));
        }
        StringBuilder builder = new StringBuilder();
        for (Character c : hex) {
            builder.append(c);
        }
        return builder.toString();
    }
}

