/*
 * Decompiled with CFR 0.152.
 */
package com.firestack.laksaj.jsonrpc;

import com.firestack.laksaj.blockchain.BlockList;
import com.firestack.laksaj.blockchain.BlockchainInfo;
import com.firestack.laksaj.blockchain.Contract;
import com.firestack.laksaj.blockchain.DsBlock;
import com.firestack.laksaj.blockchain.ShardingStructure;
import com.firestack.laksaj.blockchain.TransactionList;
import com.firestack.laksaj.blockchain.TxBlock;
import com.firestack.laksaj.jsonrpc.Rep;
import com.firestack.laksaj.jsonrpc.Req;
import com.firestack.laksaj.transaction.Transaction;
import com.firestack.laksaj.transaction.TransactionPayload;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.junit.Assert;

public class HttpProvider {
    private final OkHttpClient client = new OkHttpClient();
    private final Gson gson = new Gson();
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private String url;

    public HttpProvider(String url) {
        this.url = url;
    }

    public Rep<String> getNetworkId() throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetNetworkId").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<String>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<BlockchainInfo> getBlockchainInfo() throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetBlockchainInfo").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<BlockchainInfo>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<ShardingStructure> getShardingStructure() throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetShardingStructure").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<ShardingStructure>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<BlockList> getDSBlockListing(int pageNumber) throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("DSBlockListing").params(new Integer[]{pageNumber}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<BlockList>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<BlockList> getTxBlockListing(int pageNumber) throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("TxBlockListing").params(new Integer[]{pageNumber}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<BlockList>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<String> getNumDSBlocks() throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetNumDSBlocks").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<String>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<Double> getDSBlockRate() throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetDSBlockRate").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<Double>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<BlockList> getDSBlockListing() throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("DSBlockListing").params(new Object[]{1}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<BlockList>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<DsBlock> getDsBlock(String blockNumber) throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetDsBlock").params(new String[]{blockNumber}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<DsBlock>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<TxBlock> getTxBlock(String blockNumber) throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetTxBlock").params(new String[]{blockNumber}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, new TypeToken<Rep<TxBlock>>(){}.getType());
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<String> getNumTxBlocks() throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetNumTxBlocks").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<String>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<Double> getTxBlockRate() throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetTxBlockRate").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<Double>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<DsBlock> getLatestDsBlock() throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetLatestDsBlock").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, new TypeToken<Rep<DsBlock>>(){}.getType());
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<TxBlock> getLatestTxBlock() throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetLatestTxBlock").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, new TypeToken<Rep<TxBlock>>(){}.getType());
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<String> getNumTransactions() throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetNumTransactions").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<String>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<Integer> getTransactionRate() throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetTransactionRate").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<Integer>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<String> getCurrentMiniEpoch() throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetCurrentMiniEpoch").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<String>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<String> getCurrentDSEpoch() throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetCurrentDSEpoch").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<String>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<Integer> getPrevDifficulty() throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetPrevDifficulty").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<Integer>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<Integer> getPrevDSDifficulty() throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetPrevDSDifficulty").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<Integer>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<BalanceResult> getBalance(String address) throws IOException {
        Type type;
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetBalance").params(new String[]{address}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Rep rep = (Rep)this.gson.fromJson(resultString, type = new TypeToken<Rep<BalanceResult>>(){}.getType());
        if (null == rep.getResult()) {
            BalanceResult balanceResult = new BalanceResult();
            balanceResult.setBalance("0");
            balanceResult.setNonce("0");
            rep.setResult(balanceResult);
        }
        return rep;
    }

    public Rep<ContractResult> getSmartContractCode(String address) throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetSmartContractCode").params(new String[]{address}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<ContractResult>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)"result is null, check your account address!", rep.getResult());
        return rep;
    }

    public Rep<List<Contract>> getSmartContracts(String address) throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetSmartContracts").params(new String[]{address}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<List<Contract>>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<String> getContractAddressFromTransactionID(String address) throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetContractAddressFromTransactionID").params(new String[]{address}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<String>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<List<Contract.State>> getSmartContractState(String address) throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetSmartContractState").params(new String[]{address}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<List<Contract.State>>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<List<Contract.State>> getSmartContractInit(String address) throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetSmartContractInit").params(new String[]{address}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<List<Contract.State>>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<CreateTxResult> createTransaction(TransactionPayload payload) throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("CreateTransaction").params(new Object[]{payload}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<CreateTxResult>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<String> getMinimumGasPrice() throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetMinimumGasPrice").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<String>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<Transaction> getTransaction(String hash) throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetTransaction").params(new String[]{hash}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<Transaction>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<TransactionList> getRecentTransactions() throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetRecentTransactions").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<TransactionList>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<List<List<String>>> getTransactionsForTxBlock(String blockNum) throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetTransactionsForTxBlock").params(new String[]{blockNum}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<List<List<String>>>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<String> getNumTxnsTxEpoch() throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetNumTxnsTxEpoch").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<String>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    public Rep<String> getNumTxnsDSEpoch() throws IOException {
        Req req = Req.builder().id("1").jsonrpc("2.0").method("GetNumTxnsDSEpoch").params(new String[]{""}).build();
        Response response = this.client.newCall(this.buildRequest(req)).execute();
        String resultString = Objects.requireNonNull(response.body()).string();
        Type type = new TypeToken<Rep<String>>(){}.getType();
        Rep rep = (Rep)this.gson.fromJson(resultString, type);
        Assert.assertNotNull((String)("get result error = " + resultString), rep.getResult());
        return rep;
    }

    private Request buildRequest(Req req) throws MalformedURLException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)this.gson.toJson((Object)req));
        return new Request.Builder().post(body).url(new URL(this.url)).build();
    }

    public static class CreateTxResult {
        private String Info;
        private String TranID;

        public String toString() {
            return "CreateTxResult{Info='" + this.Info + '\'' + ", TranID='" + this.TranID + '\'' + '}';
        }

        public String getInfo() {
            return this.Info;
        }

        public String getTranID() {
            return this.TranID;
        }

        public void setInfo(String Info) {
            this.Info = Info;
        }

        public void setTranID(String TranID) {
            this.TranID = TranID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateTxResult)) {
                return false;
            }
            CreateTxResult other = (CreateTxResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$Info = this.getInfo();
            String other$Info = other.getInfo();
            if (this$Info == null ? other$Info != null : !this$Info.equals(other$Info)) {
                return false;
            }
            String this$TranID = this.getTranID();
            String other$TranID = other.getTranID();
            return !(this$TranID == null ? other$TranID != null : !this$TranID.equals(other$TranID));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CreateTxResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $Info = this.getInfo();
            result = result * 59 + ($Info == null ? 43 : $Info.hashCode());
            String $TranID = this.getTranID();
            result = result * 59 + ($TranID == null ? 43 : $TranID.hashCode());
            return result;
        }
    }

    public static class ContractResult {
        private String code;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContractResult)) {
                return false;
            }
            ContractResult other = (ContractResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            return !(this$code == null ? other$code != null : !this$code.equals(other$code));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ContractResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            return result;
        }

        public String toString() {
            return "HttpProvider.ContractResult(code=" + this.getCode() + ")";
        }
    }

    public static class BalanceResult {
        private String balance;
        private String nonce;

        public String getBalance() {
            return this.balance;
        }

        public String getNonce() {
            return this.nonce;
        }

        public void setBalance(String balance) {
            this.balance = balance;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BalanceResult)) {
                return false;
            }
            BalanceResult other = (BalanceResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$balance = this.getBalance();
            String other$balance = other.getBalance();
            if (this$balance == null ? other$balance != null : !this$balance.equals(other$balance)) {
                return false;
            }
            String this$nonce = this.getNonce();
            String other$nonce = other.getNonce();
            return !(this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BalanceResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $balance = this.getBalance();
            result = result * 59 + ($balance == null ? 43 : $balance.hashCode());
            String $nonce = this.getNonce();
            result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
            return result;
        }

        public String toString() {
            return "HttpProvider.BalanceResult(balance=" + this.getBalance() + ", nonce=" + this.getNonce() + ")";
        }
    }
}

