/*
 * Decompiled with CFR 0.152.
 */
package com.firestack.laksaj.blockchain;

import com.firestack.laksaj.blockchain.ShardingStructure;

public class BlockchainInfo {
    private int NumPeers;
    private String NumTxBlocks;
    private String NumDSBlocks;
    private String NumTransactions;
    private String TransactionRate;
    private double TxBlockRate;
    private double DSBlockRate;
    private String CurrentMiniEpoch;
    private String CurrentDSEpoch;
    private String NumTxnsDSEpoch;
    private int NumTxnsTxEpoch;
    private ShardingStructure ShardingStructure;

    BlockchainInfo(int NumPeers, String NumTxBlocks, String NumDSBlocks, String NumTransactions, String TransactionRate, double TxBlockRate, double DSBlockRate, String CurrentMiniEpoch, String CurrentDSEpoch, String NumTxnsDSEpoch, int NumTxnsTxEpoch, ShardingStructure ShardingStructure2) {
        this.NumPeers = NumPeers;
        this.NumTxBlocks = NumTxBlocks;
        this.NumDSBlocks = NumDSBlocks;
        this.NumTransactions = NumTransactions;
        this.TransactionRate = TransactionRate;
        this.TxBlockRate = TxBlockRate;
        this.DSBlockRate = DSBlockRate;
        this.CurrentMiniEpoch = CurrentMiniEpoch;
        this.CurrentDSEpoch = CurrentDSEpoch;
        this.NumTxnsDSEpoch = NumTxnsDSEpoch;
        this.NumTxnsTxEpoch = NumTxnsTxEpoch;
        this.ShardingStructure = ShardingStructure2;
    }

    public static BlockchainInfoBuilder builder() {
        return new BlockchainInfoBuilder();
    }

    public int getNumPeers() {
        return this.NumPeers;
    }

    public String getNumTxBlocks() {
        return this.NumTxBlocks;
    }

    public String getNumDSBlocks() {
        return this.NumDSBlocks;
    }

    public String getNumTransactions() {
        return this.NumTransactions;
    }

    public String getTransactionRate() {
        return this.TransactionRate;
    }

    public double getTxBlockRate() {
        return this.TxBlockRate;
    }

    public double getDSBlockRate() {
        return this.DSBlockRate;
    }

    public String getCurrentMiniEpoch() {
        return this.CurrentMiniEpoch;
    }

    public String getCurrentDSEpoch() {
        return this.CurrentDSEpoch;
    }

    public String getNumTxnsDSEpoch() {
        return this.NumTxnsDSEpoch;
    }

    public int getNumTxnsTxEpoch() {
        return this.NumTxnsTxEpoch;
    }

    public ShardingStructure getShardingStructure() {
        return this.ShardingStructure;
    }

    public void setNumPeers(int NumPeers) {
        this.NumPeers = NumPeers;
    }

    public void setNumTxBlocks(String NumTxBlocks) {
        this.NumTxBlocks = NumTxBlocks;
    }

    public void setNumDSBlocks(String NumDSBlocks) {
        this.NumDSBlocks = NumDSBlocks;
    }

    public void setNumTransactions(String NumTransactions) {
        this.NumTransactions = NumTransactions;
    }

    public void setTransactionRate(String TransactionRate) {
        this.TransactionRate = TransactionRate;
    }

    public void setTxBlockRate(double TxBlockRate) {
        this.TxBlockRate = TxBlockRate;
    }

    public void setDSBlockRate(double DSBlockRate) {
        this.DSBlockRate = DSBlockRate;
    }

    public void setCurrentMiniEpoch(String CurrentMiniEpoch) {
        this.CurrentMiniEpoch = CurrentMiniEpoch;
    }

    public void setCurrentDSEpoch(String CurrentDSEpoch) {
        this.CurrentDSEpoch = CurrentDSEpoch;
    }

    public void setNumTxnsDSEpoch(String NumTxnsDSEpoch) {
        this.NumTxnsDSEpoch = NumTxnsDSEpoch;
    }

    public void setNumTxnsTxEpoch(int NumTxnsTxEpoch) {
        this.NumTxnsTxEpoch = NumTxnsTxEpoch;
    }

    public void setShardingStructure(ShardingStructure ShardingStructure2) {
        this.ShardingStructure = ShardingStructure2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockchainInfo)) {
            return false;
        }
        BlockchainInfo other = (BlockchainInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumPeers() != other.getNumPeers()) {
            return false;
        }
        String this$NumTxBlocks = this.getNumTxBlocks();
        String other$NumTxBlocks = other.getNumTxBlocks();
        if (this$NumTxBlocks == null ? other$NumTxBlocks != null : !this$NumTxBlocks.equals(other$NumTxBlocks)) {
            return false;
        }
        String this$NumDSBlocks = this.getNumDSBlocks();
        String other$NumDSBlocks = other.getNumDSBlocks();
        if (this$NumDSBlocks == null ? other$NumDSBlocks != null : !this$NumDSBlocks.equals(other$NumDSBlocks)) {
            return false;
        }
        String this$NumTransactions = this.getNumTransactions();
        String other$NumTransactions = other.getNumTransactions();
        if (this$NumTransactions == null ? other$NumTransactions != null : !this$NumTransactions.equals(other$NumTransactions)) {
            return false;
        }
        String this$TransactionRate = this.getTransactionRate();
        String other$TransactionRate = other.getTransactionRate();
        if (this$TransactionRate == null ? other$TransactionRate != null : !this$TransactionRate.equals(other$TransactionRate)) {
            return false;
        }
        if (Double.compare(this.getTxBlockRate(), other.getTxBlockRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getDSBlockRate(), other.getDSBlockRate()) != 0) {
            return false;
        }
        String this$CurrentMiniEpoch = this.getCurrentMiniEpoch();
        String other$CurrentMiniEpoch = other.getCurrentMiniEpoch();
        if (this$CurrentMiniEpoch == null ? other$CurrentMiniEpoch != null : !this$CurrentMiniEpoch.equals(other$CurrentMiniEpoch)) {
            return false;
        }
        String this$CurrentDSEpoch = this.getCurrentDSEpoch();
        String other$CurrentDSEpoch = other.getCurrentDSEpoch();
        if (this$CurrentDSEpoch == null ? other$CurrentDSEpoch != null : !this$CurrentDSEpoch.equals(other$CurrentDSEpoch)) {
            return false;
        }
        String this$NumTxnsDSEpoch = this.getNumTxnsDSEpoch();
        String other$NumTxnsDSEpoch = other.getNumTxnsDSEpoch();
        if (this$NumTxnsDSEpoch == null ? other$NumTxnsDSEpoch != null : !this$NumTxnsDSEpoch.equals(other$NumTxnsDSEpoch)) {
            return false;
        }
        if (this.getNumTxnsTxEpoch() != other.getNumTxnsTxEpoch()) {
            return false;
        }
        ShardingStructure this$ShardingStructure = this.getShardingStructure();
        ShardingStructure other$ShardingStructure = other.getShardingStructure();
        return !(this$ShardingStructure == null ? other$ShardingStructure != null : !((Object)this$ShardingStructure).equals(other$ShardingStructure));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockchainInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumPeers();
        String $NumTxBlocks = this.getNumTxBlocks();
        result = result * 59 + ($NumTxBlocks == null ? 43 : $NumTxBlocks.hashCode());
        String $NumDSBlocks = this.getNumDSBlocks();
        result = result * 59 + ($NumDSBlocks == null ? 43 : $NumDSBlocks.hashCode());
        String $NumTransactions = this.getNumTransactions();
        result = result * 59 + ($NumTransactions == null ? 43 : $NumTransactions.hashCode());
        String $TransactionRate = this.getTransactionRate();
        result = result * 59 + ($TransactionRate == null ? 43 : $TransactionRate.hashCode());
        long $TxBlockRate = Double.doubleToLongBits(this.getTxBlockRate());
        result = result * 59 + (int)($TxBlockRate >>> 32 ^ $TxBlockRate);
        long $DSBlockRate = Double.doubleToLongBits(this.getDSBlockRate());
        result = result * 59 + (int)($DSBlockRate >>> 32 ^ $DSBlockRate);
        String $CurrentMiniEpoch = this.getCurrentMiniEpoch();
        result = result * 59 + ($CurrentMiniEpoch == null ? 43 : $CurrentMiniEpoch.hashCode());
        String $CurrentDSEpoch = this.getCurrentDSEpoch();
        result = result * 59 + ($CurrentDSEpoch == null ? 43 : $CurrentDSEpoch.hashCode());
        String $NumTxnsDSEpoch = this.getNumTxnsDSEpoch();
        result = result * 59 + ($NumTxnsDSEpoch == null ? 43 : $NumTxnsDSEpoch.hashCode());
        result = result * 59 + this.getNumTxnsTxEpoch();
        ShardingStructure $ShardingStructure = this.getShardingStructure();
        result = result * 59 + ($ShardingStructure == null ? 43 : ((Object)$ShardingStructure).hashCode());
        return result;
    }

    public String toString() {
        return "BlockchainInfo(NumPeers=" + this.getNumPeers() + ", NumTxBlocks=" + this.getNumTxBlocks() + ", NumDSBlocks=" + this.getNumDSBlocks() + ", NumTransactions=" + this.getNumTransactions() + ", TransactionRate=" + this.getTransactionRate() + ", TxBlockRate=" + this.getTxBlockRate() + ", DSBlockRate=" + this.getDSBlockRate() + ", CurrentMiniEpoch=" + this.getCurrentMiniEpoch() + ", CurrentDSEpoch=" + this.getCurrentDSEpoch() + ", NumTxnsDSEpoch=" + this.getNumTxnsDSEpoch() + ", NumTxnsTxEpoch=" + this.getNumTxnsTxEpoch() + ", ShardingStructure=" + this.getShardingStructure() + ")";
    }

    public static class BlockchainInfoBuilder {
        private int NumPeers;
        private String NumTxBlocks;
        private String NumDSBlocks;
        private String NumTransactions;
        private String TransactionRate;
        private double TxBlockRate;
        private double DSBlockRate;
        private String CurrentMiniEpoch;
        private String CurrentDSEpoch;
        private String NumTxnsDSEpoch;
        private int NumTxnsTxEpoch;
        private ShardingStructure ShardingStructure;

        BlockchainInfoBuilder() {
        }

        public BlockchainInfoBuilder NumPeers(int NumPeers) {
            this.NumPeers = NumPeers;
            return this;
        }

        public BlockchainInfoBuilder NumTxBlocks(String NumTxBlocks) {
            this.NumTxBlocks = NumTxBlocks;
            return this;
        }

        public BlockchainInfoBuilder NumDSBlocks(String NumDSBlocks) {
            this.NumDSBlocks = NumDSBlocks;
            return this;
        }

        public BlockchainInfoBuilder NumTransactions(String NumTransactions) {
            this.NumTransactions = NumTransactions;
            return this;
        }

        public BlockchainInfoBuilder TransactionRate(String TransactionRate) {
            this.TransactionRate = TransactionRate;
            return this;
        }

        public BlockchainInfoBuilder TxBlockRate(double TxBlockRate) {
            this.TxBlockRate = TxBlockRate;
            return this;
        }

        public BlockchainInfoBuilder DSBlockRate(double DSBlockRate) {
            this.DSBlockRate = DSBlockRate;
            return this;
        }

        public BlockchainInfoBuilder CurrentMiniEpoch(String CurrentMiniEpoch) {
            this.CurrentMiniEpoch = CurrentMiniEpoch;
            return this;
        }

        public BlockchainInfoBuilder CurrentDSEpoch(String CurrentDSEpoch) {
            this.CurrentDSEpoch = CurrentDSEpoch;
            return this;
        }

        public BlockchainInfoBuilder NumTxnsDSEpoch(String NumTxnsDSEpoch) {
            this.NumTxnsDSEpoch = NumTxnsDSEpoch;
            return this;
        }

        public BlockchainInfoBuilder NumTxnsTxEpoch(int NumTxnsTxEpoch) {
            this.NumTxnsTxEpoch = NumTxnsTxEpoch;
            return this;
        }

        public BlockchainInfoBuilder ShardingStructure(ShardingStructure ShardingStructure2) {
            this.ShardingStructure = ShardingStructure2;
            return this;
        }

        public BlockchainInfo build() {
            return new BlockchainInfo(this.NumPeers, this.NumTxBlocks, this.NumDSBlocks, this.NumTransactions, this.TransactionRate, this.TxBlockRate, this.DSBlockRate, this.CurrentMiniEpoch, this.CurrentDSEpoch, this.NumTxnsDSEpoch, this.NumTxnsTxEpoch, this.ShardingStructure);
        }

        public String toString() {
            return "BlockchainInfo.BlockchainInfoBuilder(NumPeers=" + this.NumPeers + ", NumTxBlocks=" + this.NumTxBlocks + ", NumDSBlocks=" + this.NumDSBlocks + ", NumTransactions=" + this.NumTransactions + ", TransactionRate=" + this.TransactionRate + ", TxBlockRate=" + this.TxBlockRate + ", DSBlockRate=" + this.DSBlockRate + ", CurrentMiniEpoch=" + this.CurrentMiniEpoch + ", CurrentDSEpoch=" + this.CurrentDSEpoch + ", NumTxnsDSEpoch=" + this.NumTxnsDSEpoch + ", NumTxnsTxEpoch=" + this.NumTxnsTxEpoch + ", ShardingStructure=" + this.ShardingStructure + ")";
        }
    }
}

