/*
 * Decompiled with CFR 0.152.
 */
package com.firestack.laksaj.transaction;

import com.firestack.laksaj.account.Account;
import com.firestack.laksaj.blockchain.TransactionReceipt;
import com.firestack.laksaj.jsonrpc.HttpProvider;
import com.firestack.laksaj.transaction.TransactionPayload;
import com.firestack.laksaj.transaction.TxParams;
import com.firestack.laksaj.transaction.TxStatus;
import com.firestack.laksaj.utils.Base58;
import com.firestack.laksaj.utils.ByteUtil;
import com.firestack.laksaj.utils.TransactionUtil;
import com.google.gson.Gson;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;

public class Transaction {
    private String ID;
    private String version;
    private String nonce;
    private String amount;
    private String gasPrice;
    private String gasLimit;
    private String signature;
    private TransactionReceipt receipt;
    private String senderPubKey;
    private String toAddr;
    private String code;
    private String data;
    private HttpProvider provider;
    private TxStatus status;

    public TxParams toTransactionParam() throws IOException {
        if (Base58.isBase58(this.getToAddr())) {
            this.marshalToAddress();
        }
        return TxParams.builder().ID(this.ID).version(this.version).nonce(this.nonce).amount(this.amount).gasPrice(this.gasPrice).gasLimit(this.gasLimit).signature(this.signature).receipt(this.receipt).senderPubKey(this.senderPubKey.toLowerCase()).toAddr(this.toAddr == null ? "0000000000000000000000000000000000000000" : this.toAddr.toLowerCase()).code(this.code).data(this.data).build();
    }

    public TransactionPayload toTransactionPayload() {
        return TransactionPayload.builder().version(Integer.parseInt(this.version)).nonce(Integer.valueOf(this.nonce)).toAddr(Account.toCheckSumAddress(this.toAddr).substring(2)).amount(this.amount).pubKey(this.senderPubKey.toLowerCase()).gasPrice(this.gasPrice).gasLimit(this.gasLimit).code(this.code).data(this.data).signature(this.signature.toLowerCase()).build();
    }

    public void marshalToAddress() throws IOException {
        byte[] address = Base58.decode(this.getToAddr());
        this.setToAddr(ByteUtil.byteArrayToHexString(address));
    }

    public byte[] bytes() throws IOException {
        TxParams txParams = this.toTransactionParam();
        TransactionUtil util = new TransactionUtil();
        Gson gson = new Gson();
        byte[] bytes = util.encodeTransactionProto(txParams);
        return bytes;
    }

    public boolean isPending() {
        return this.status.equals((Object)TxStatus.Pending);
    }

    public boolean isInitialised() {
        return this.status.equals((Object)TxStatus.Initialised);
    }

    public boolean isConfirmed() {
        return this.status.equals((Object)TxStatus.Confirmed);
    }

    public boolean isRejected() {
        return this.status.equals((Object)TxStatus.Rejected);
    }

    public Transaction confirm(String txHash, int maxAttempts, int interval) throws InterruptedException {
        this.setStatus(TxStatus.Pending);
        for (int i = 0; i < maxAttempts; ++i) {
            boolean tracked = this.trackTx(txHash);
            Thread.sleep(Duration.of(interval, ChronoUnit.SECONDS).toMillis());
            if (!tracked) continue;
            this.setStatus(TxStatus.Confirmed);
            return this;
        }
        this.status = TxStatus.Rejected;
        return this;
    }

    public boolean trackTx(String txHash) {
        Transaction response;
        System.out.println("tracking transaction: " + txHash);
        try {
            response = this.provider.getTransaction(txHash).getResult();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("transaction not confirmed yet");
            return false;
        }
        if (null == response) {
            System.out.println("transaction not confirmed yet");
            return false;
        }
        this.setID(response.getID());
        this.setReceipt(response.getReceipt());
        if (response.getReceipt() != null && response.getReceipt().isSuccess()) {
            System.out.println("Transaction confirmed!");
            this.setStatus(TxStatus.Confirmed);
        } else {
            this.setStatus(TxStatus.Rejected);
            System.out.println("Transaction rejected!");
        }
        return true;
    }

    Transaction(String ID, String version, String nonce, String amount, String gasPrice, String gasLimit, String signature, TransactionReceipt receipt, String senderPubKey, String toAddr, String code, String data2, HttpProvider provider, TxStatus status) {
        this.ID = ID;
        this.version = version;
        this.nonce = nonce;
        this.amount = amount;
        this.gasPrice = gasPrice;
        this.gasLimit = gasLimit;
        this.signature = signature;
        this.receipt = receipt;
        this.senderPubKey = senderPubKey;
        this.toAddr = toAddr;
        this.code = code;
        this.data = data2;
        this.provider = provider;
        this.status = status;
    }

    public static TransactionBuilder builder() {
        return new TransactionBuilder();
    }

    public String getID() {
        return this.ID;
    }

    public String getVersion() {
        return this.version;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getAmount() {
        return this.amount;
    }

    public String getGasPrice() {
        return this.gasPrice;
    }

    public String getGasLimit() {
        return this.gasLimit;
    }

    public String getSignature() {
        return this.signature;
    }

    public TransactionReceipt getReceipt() {
        return this.receipt;
    }

    public String getSenderPubKey() {
        return this.senderPubKey;
    }

    public String getToAddr() {
        return this.toAddr;
    }

    public String getCode() {
        return this.code;
    }

    public String getData() {
        return this.data;
    }

    public HttpProvider getProvider() {
        return this.provider;
    }

    public TxStatus getStatus() {
        return this.status;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public void setGasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
    }

    public void setGasLimit(String gasLimit) {
        this.gasLimit = gasLimit;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void setReceipt(TransactionReceipt receipt) {
        this.receipt = receipt;
    }

    public void setSenderPubKey(String senderPubKey) {
        this.senderPubKey = senderPubKey;
    }

    public void setToAddr(String toAddr) {
        this.toAddr = toAddr;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setData(String data2) {
        this.data = data2;
    }

    public void setProvider(HttpProvider provider) {
        this.provider = provider;
    }

    public void setStatus(TxStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$ID = this.getID();
        String other$ID = other.getID();
        if (this$ID == null ? other$ID != null : !this$ID.equals(other$ID)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$nonce = this.getNonce();
        String other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce)) {
            return false;
        }
        String this$amount = this.getAmount();
        String other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
            return false;
        }
        String this$gasPrice = this.getGasPrice();
        String other$gasPrice = other.getGasPrice();
        if (this$gasPrice == null ? other$gasPrice != null : !this$gasPrice.equals(other$gasPrice)) {
            return false;
        }
        String this$gasLimit = this.getGasLimit();
        String other$gasLimit = other.getGasLimit();
        if (this$gasLimit == null ? other$gasLimit != null : !this$gasLimit.equals(other$gasLimit)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
            return false;
        }
        TransactionReceipt this$receipt = this.getReceipt();
        TransactionReceipt other$receipt = other.getReceipt();
        if (this$receipt == null ? other$receipt != null : !((Object)this$receipt).equals(other$receipt)) {
            return false;
        }
        String this$senderPubKey = this.getSenderPubKey();
        String other$senderPubKey = other.getSenderPubKey();
        if (this$senderPubKey == null ? other$senderPubKey != null : !this$senderPubKey.equals(other$senderPubKey)) {
            return false;
        }
        String this$toAddr = this.getToAddr();
        String other$toAddr = other.getToAddr();
        if (this$toAddr == null ? other$toAddr != null : !this$toAddr.equals(other$toAddr)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        HttpProvider this$provider = this.getProvider();
        HttpProvider other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        TxStatus this$status = this.getStatus();
        TxStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Transaction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ID = this.getID();
        result = result * 59 + ($ID == null ? 43 : $ID.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
        String $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        String $gasPrice = this.getGasPrice();
        result = result * 59 + ($gasPrice == null ? 43 : $gasPrice.hashCode());
        String $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : $gasLimit.hashCode());
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        TransactionReceipt $receipt = this.getReceipt();
        result = result * 59 + ($receipt == null ? 43 : ((Object)$receipt).hashCode());
        String $senderPubKey = this.getSenderPubKey();
        result = result * 59 + ($senderPubKey == null ? 43 : $senderPubKey.hashCode());
        String $toAddr = this.getToAddr();
        result = result * 59 + ($toAddr == null ? 43 : $toAddr.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        HttpProvider $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        TxStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public String toString() {
        return "Transaction(ID=" + this.getID() + ", version=" + this.getVersion() + ", nonce=" + this.getNonce() + ", amount=" + this.getAmount() + ", gasPrice=" + this.getGasPrice() + ", gasLimit=" + this.getGasLimit() + ", signature=" + this.getSignature() + ", receipt=" + this.getReceipt() + ", senderPubKey=" + this.getSenderPubKey() + ", toAddr=" + this.getToAddr() + ", code=" + this.getCode() + ", data=" + this.getData() + ", provider=" + this.getProvider() + ", status=" + (Object)((Object)this.getStatus()) + ")";
    }

    public static class TransactionBuilder {
        private String ID;
        private String version;
        private String nonce;
        private String amount;
        private String gasPrice;
        private String gasLimit;
        private String signature;
        private TransactionReceipt receipt;
        private String senderPubKey;
        private String toAddr;
        private String code;
        private String data;
        private HttpProvider provider;
        private TxStatus status;

        TransactionBuilder() {
        }

        public TransactionBuilder ID(String ID) {
            this.ID = ID;
            return this;
        }

        public TransactionBuilder version(String version) {
            this.version = version;
            return this;
        }

        public TransactionBuilder nonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public TransactionBuilder amount(String amount) {
            this.amount = amount;
            return this;
        }

        public TransactionBuilder gasPrice(String gasPrice) {
            this.gasPrice = gasPrice;
            return this;
        }

        public TransactionBuilder gasLimit(String gasLimit) {
            this.gasLimit = gasLimit;
            return this;
        }

        public TransactionBuilder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public TransactionBuilder receipt(TransactionReceipt receipt) {
            this.receipt = receipt;
            return this;
        }

        public TransactionBuilder senderPubKey(String senderPubKey) {
            this.senderPubKey = senderPubKey;
            return this;
        }

        public TransactionBuilder toAddr(String toAddr) {
            this.toAddr = toAddr;
            return this;
        }

        public TransactionBuilder code(String code) {
            this.code = code;
            return this;
        }

        public TransactionBuilder data(String data2) {
            this.data = data2;
            return this;
        }

        public TransactionBuilder provider(HttpProvider provider) {
            this.provider = provider;
            return this;
        }

        public TransactionBuilder status(TxStatus status) {
            this.status = status;
            return this;
        }

        public Transaction build() {
            return new Transaction(this.ID, this.version, this.nonce, this.amount, this.gasPrice, this.gasLimit, this.signature, this.receipt, this.senderPubKey, this.toAddr, this.code, this.data, this.provider, this.status);
        }

        public String toString() {
            return "Transaction.TransactionBuilder(ID=" + this.ID + ", version=" + this.version + ", nonce=" + this.nonce + ", amount=" + this.amount + ", gasPrice=" + this.gasPrice + ", gasLimit=" + this.gasLimit + ", signature=" + this.signature + ", receipt=" + this.receipt + ", senderPubKey=" + this.senderPubKey + ", toAddr=" + this.toAddr + ", code=" + this.code + ", data=" + this.data + ", provider=" + this.provider + ", status=" + (Object)((Object)this.status) + ")";
        }
    }
}

