/*
 * Decompiled with CFR 0.152.
 */
package com.firestack.laksaj.crypto;

import com.firestack.laksaj.crypto.KDFParams;
import com.firestack.laksaj.crypto.KDFType;
import com.firestack.laksaj.crypto.KeyTools;
import com.firestack.laksaj.crypto.PBKDF2Params;
import com.firestack.laksaj.crypto.PBKDF2Wrapper;
import com.firestack.laksaj.crypto.ScryptParams;
import com.firestack.laksaj.crypto.ScryptWrapper;
import com.firestack.laksaj.utils.ByteUtil;
import com.firestack.laksaj.utils.HashUtil;
import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.util.Arrays;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class KeyStore {
    private PBKDF2Wrapper pbkdf2Wrapper;
    private ScryptWrapper scryptWrapper;
    private Gson gson = new Gson();

    public KeyStore(PBKDF2Wrapper pbkdf2Wrapper, ScryptWrapper scryptWrapper) {
        this.pbkdf2Wrapper = pbkdf2Wrapper;
        this.scryptWrapper = scryptWrapper;
    }

    public static KeyStore defaultKeyStore() {
        return new KeyStore(new PBKDF2Wrapper(), new ScryptWrapper());
    }

    public byte[] getDerivedKey(byte[] password, KDFParams params) throws UnsupportedEncodingException {
        if (params instanceof PBKDF2Params) {
            PBKDF2Params pbkdf2Params = (PBKDF2Params)params;
            return this.pbkdf2Wrapper.getDerivedKey(password, ByteUtil.hexStringToByteArray(pbkdf2Params.getSalt()), pbkdf2Params.getCount(), pbkdf2Params.getDkLen());
        }
        if (params instanceof ScryptParams) {
            ScryptParams scryptParams = (ScryptParams)params;
            return this.scryptWrapper.getDerivedKey(password, ByteUtil.hexStringToByteArray(scryptParams.getSalt()), scryptParams.getN(), scryptParams.getR(), scryptParams.getP(), scryptParams.getDkLen());
        }
        throw new IllegalArgumentException("unsupport kdf params");
    }

    public String encryptPrivateKey(String privateKey, String passphrase, KDFType type) throws Exception {
        byte[] derivedKey;
        String address = KeyTools.getAddressFromPrivateKey(privateKey);
        byte[] iv = KeyTools.generateRandomBytes(16);
        byte[] salt = KeyTools.generateRandomBytes(32);
        if (type.equals((Object)KDFType.PBKDF2)) {
            PBKDF2Params pbkdf2Params = PBKDF2Params.builder().salt(ByteUtil.byteArrayToHexString(salt)).dkLen(32).count(262144).build();
            derivedKey = this.getDerivedKey(passphrase.getBytes(), pbkdf2Params);
        } else {
            ScryptParams scryptParams = ScryptParams.builder().salt(ByteUtil.byteArrayToHexString(salt)).dkLen(32).p(1).r(8).n(8192).build();
            derivedKey = this.getDerivedKey(passphrase.getBytes(), scryptParams);
        }
        byte[] encryptKey = Arrays.copyOfRange(derivedKey, 0, 16);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
        SecretKeySpec secretKeySpec = new SecretKeySpec(encryptKey, "AES");
        cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
        byte[] ciphertext = cipher.doFinal(ByteUtil.hexStringToByteArray(privateKey));
        byte[] mac = HashUtil.generateMac(derivedKey, ciphertext);
        CipherParams cipherParams = CipherParams.builder().iv(ByteUtil.byteArrayToHexString(iv)).build();
        kdfparams kp = new kdfparams(salt);
        Crypto crypto = Crypto.builder().cipher("aes-128-ctr").cipherparams(cipherParams).ciphertext(ByteUtil.byteArrayToHexString(ciphertext)).kdf(type.equals((Object)KDFType.PBKDF2) ? "pbkdf2" : "scrypt").kdfparams(kp).mac(ByteUtil.byteArrayToHexString(mac)).build();
        KeystoreV3 struct = KeystoreV3.builder().address(address).crypto(crypto).id(UUID.randomUUID().toString()).version(3).build();
        return this.gson.toJson((Object)struct);
    }

    public String decryptPrivateKey(String encryptJson, String passphrase) throws Exception {
        byte[] derivedKey;
        KeystoreV3 keystoreV3 = (KeystoreV3)this.gson.fromJson(encryptJson, KeystoreV3.class);
        byte[] ciphertext = ByteUtil.hexStringToByteArray(keystoreV3.crypto.ciphertext);
        byte[] iv = ByteUtil.hexStringToByteArray(keystoreV3.crypto.cipherparams.iv);
        kdfparams kp = keystoreV3.crypto.kdfparams;
        String kdf = keystoreV3.crypto.kdf;
        if (kdf.equals("pbkdf2")) {
            PBKDF2Params pbkdf2Params = PBKDF2Params.builder().salt(ByteUtil.byteArrayToHexString(kp.salt)).dkLen(32).count(262144).build();
            derivedKey = this.getDerivedKey(passphrase.getBytes(), pbkdf2Params);
        } else {
            ScryptParams scryptParams = ScryptParams.builder().salt(ByteUtil.byteArrayToHexString(kp.salt)).dkLen(32).p(1).r(8).n(8192).build();
            derivedKey = this.getDerivedKey(passphrase.getBytes(), scryptParams);
        }
        String mac = ByteUtil.byteArrayToHexString(HashUtil.generateMac(derivedKey, ciphertext));
        if (!mac.toUpperCase().equals(keystoreV3.crypto.mac)) {
            throw new IllegalAccessException("Failed to decrypt.");
        }
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
        byte[] encryptKey = Arrays.copyOfRange(derivedKey, 0, 16);
        SecretKeySpec secretKeySpec = new SecretKeySpec(encryptKey, "AES");
        cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
        return ByteUtil.byteArrayToHexString(cipher.doFinal(ciphertext));
    }

    private static class kdfparams {
        private int n = 8192;
        private int c = 262144;
        private int r = 8;
        private int p = 1;
        private int dklen = 32;
        private byte[] salt;

        public kdfparams(byte[] salt) {
            this.salt = salt;
        }

        public int getN() {
            return this.n;
        }

        public int getC() {
            return this.c;
        }

        public int getR() {
            return this.r;
        }

        public int getP() {
            return this.p;
        }

        public int getDklen() {
            return this.dklen;
        }

        public byte[] getSalt() {
            return this.salt;
        }

        public void setN(int n) {
            this.n = n;
        }

        public void setC(int c) {
            this.c = c;
        }

        public void setR(int r) {
            this.r = r;
        }

        public void setP(int p) {
            this.p = p;
        }

        public void setDklen(int dklen) {
            this.dklen = dklen;
        }

        public void setSalt(byte[] salt) {
            this.salt = salt;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof kdfparams)) {
                return false;
            }
            kdfparams other = (kdfparams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getN() != other.getN()) {
                return false;
            }
            if (this.getC() != other.getC()) {
                return false;
            }
            if (this.getR() != other.getR()) {
                return false;
            }
            if (this.getP() != other.getP()) {
                return false;
            }
            if (this.getDklen() != other.getDklen()) {
                return false;
            }
            return Arrays.equals(this.getSalt(), other.getSalt());
        }

        protected boolean canEqual(Object other) {
            return other instanceof kdfparams;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getN();
            result = result * 59 + this.getC();
            result = result * 59 + this.getR();
            result = result * 59 + this.getP();
            result = result * 59 + this.getDklen();
            result = result * 59 + Arrays.hashCode(this.getSalt());
            return result;
        }

        public String toString() {
            return "KeyStore.kdfparams(n=" + this.getN() + ", c=" + this.getC() + ", r=" + this.getR() + ", p=" + this.getP() + ", dklen=" + this.getDklen() + ", salt=" + Arrays.toString(this.getSalt()) + ")";
        }
    }

    private static class CipherParams {
        private String iv;

        CipherParams(String iv) {
            this.iv = iv;
        }

        public static CipherParamsBuilder builder() {
            return new CipherParamsBuilder();
        }

        public String getIv() {
            return this.iv;
        }

        public void setIv(String iv) {
            this.iv = iv;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CipherParams)) {
                return false;
            }
            CipherParams other = (CipherParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$iv = this.getIv();
            String other$iv = other.getIv();
            return !(this$iv == null ? other$iv != null : !this$iv.equals(other$iv));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CipherParams;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $iv = this.getIv();
            result = result * 59 + ($iv == null ? 43 : $iv.hashCode());
            return result;
        }

        public String toString() {
            return "KeyStore.CipherParams(iv=" + this.getIv() + ")";
        }

        public static class CipherParamsBuilder {
            private String iv;

            CipherParamsBuilder() {
            }

            public CipherParamsBuilder iv(String iv) {
                this.iv = iv;
                return this;
            }

            public CipherParams build() {
                return new CipherParams(this.iv);
            }

            public String toString() {
                return "KeyStore.CipherParams.CipherParamsBuilder(iv=" + this.iv + ")";
            }
        }
    }

    public static class Crypto {
        private String cipher;
        private CipherParams cipherparams;
        private String ciphertext;
        private String kdf;
        private kdfparams kdfparams;
        private String mac;

        Crypto(String cipher, CipherParams cipherparams, String ciphertext, String kdf, kdfparams kdfparams2, String mac) {
            this.cipher = cipher;
            this.cipherparams = cipherparams;
            this.ciphertext = ciphertext;
            this.kdf = kdf;
            this.kdfparams = kdfparams2;
            this.mac = mac;
        }

        public static CryptoBuilder builder() {
            return new CryptoBuilder();
        }

        public String getCipher() {
            return this.cipher;
        }

        public CipherParams getCipherparams() {
            return this.cipherparams;
        }

        public String getCiphertext() {
            return this.ciphertext;
        }

        public String getKdf() {
            return this.kdf;
        }

        public kdfparams getKdfparams() {
            return this.kdfparams;
        }

        public String getMac() {
            return this.mac;
        }

        public void setCipher(String cipher) {
            this.cipher = cipher;
        }

        public void setCipherparams(CipherParams cipherparams) {
            this.cipherparams = cipherparams;
        }

        public void setCiphertext(String ciphertext) {
            this.ciphertext = ciphertext;
        }

        public void setKdf(String kdf) {
            this.kdf = kdf;
        }

        public void setKdfparams(kdfparams kdfparams2) {
            this.kdfparams = kdfparams2;
        }

        public void setMac(String mac) {
            this.mac = mac;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Crypto)) {
                return false;
            }
            Crypto other = (Crypto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$cipher = this.getCipher();
            String other$cipher = other.getCipher();
            if (this$cipher == null ? other$cipher != null : !this$cipher.equals(other$cipher)) {
                return false;
            }
            CipherParams this$cipherparams = this.getCipherparams();
            CipherParams other$cipherparams = other.getCipherparams();
            if (this$cipherparams == null ? other$cipherparams != null : !((Object)this$cipherparams).equals(other$cipherparams)) {
                return false;
            }
            String this$ciphertext = this.getCiphertext();
            String other$ciphertext = other.getCiphertext();
            if (this$ciphertext == null ? other$ciphertext != null : !this$ciphertext.equals(other$ciphertext)) {
                return false;
            }
            String this$kdf = this.getKdf();
            String other$kdf = other.getKdf();
            if (this$kdf == null ? other$kdf != null : !this$kdf.equals(other$kdf)) {
                return false;
            }
            kdfparams this$kdfparams = this.getKdfparams();
            kdfparams other$kdfparams = other.getKdfparams();
            if (this$kdfparams == null ? other$kdfparams != null : !((Object)this$kdfparams).equals(other$kdfparams)) {
                return false;
            }
            String this$mac = this.getMac();
            String other$mac = other.getMac();
            return !(this$mac == null ? other$mac != null : !this$mac.equals(other$mac));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Crypto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $cipher = this.getCipher();
            result = result * 59 + ($cipher == null ? 43 : $cipher.hashCode());
            CipherParams $cipherparams = this.getCipherparams();
            result = result * 59 + ($cipherparams == null ? 43 : ((Object)$cipherparams).hashCode());
            String $ciphertext = this.getCiphertext();
            result = result * 59 + ($ciphertext == null ? 43 : $ciphertext.hashCode());
            String $kdf = this.getKdf();
            result = result * 59 + ($kdf == null ? 43 : $kdf.hashCode());
            kdfparams $kdfparams = this.getKdfparams();
            result = result * 59 + ($kdfparams == null ? 43 : ((Object)$kdfparams).hashCode());
            String $mac = this.getMac();
            result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
            return result;
        }

        public String toString() {
            return "KeyStore.Crypto(cipher=" + this.getCipher() + ", cipherparams=" + this.getCipherparams() + ", ciphertext=" + this.getCiphertext() + ", kdf=" + this.getKdf() + ", kdfparams=" + this.getKdfparams() + ", mac=" + this.getMac() + ")";
        }

        public static class CryptoBuilder {
            private String cipher;
            private CipherParams cipherparams;
            private String ciphertext;
            private String kdf;
            private kdfparams kdfparams;
            private String mac;

            CryptoBuilder() {
            }

            public CryptoBuilder cipher(String cipher) {
                this.cipher = cipher;
                return this;
            }

            public CryptoBuilder cipherparams(CipherParams cipherparams) {
                this.cipherparams = cipherparams;
                return this;
            }

            public CryptoBuilder ciphertext(String ciphertext) {
                this.ciphertext = ciphertext;
                return this;
            }

            public CryptoBuilder kdf(String kdf) {
                this.kdf = kdf;
                return this;
            }

            public CryptoBuilder kdfparams(kdfparams kdfparams2) {
                this.kdfparams = kdfparams2;
                return this;
            }

            public CryptoBuilder mac(String mac) {
                this.mac = mac;
                return this;
            }

            public Crypto build() {
                return new Crypto(this.cipher, this.cipherparams, this.ciphertext, this.kdf, this.kdfparams, this.mac);
            }

            public String toString() {
                return "KeyStore.Crypto.CryptoBuilder(cipher=" + this.cipher + ", cipherparams=" + this.cipherparams + ", ciphertext=" + this.ciphertext + ", kdf=" + this.kdf + ", kdfparams=" + this.kdfparams + ", mac=" + this.mac + ")";
            }
        }
    }

    public static class KeystoreV3 {
        private String address;
        private Crypto crypto;
        private String id;
        private int version;

        KeystoreV3(String address, Crypto crypto, String id, int version) {
            this.address = address;
            this.crypto = crypto;
            this.id = id;
            this.version = version;
        }

        public static KeystoreV3Builder builder() {
            return new KeystoreV3Builder();
        }

        public String getAddress() {
            return this.address;
        }

        public Crypto getCrypto() {
            return this.crypto;
        }

        public String getId() {
            return this.id;
        }

        public int getVersion() {
            return this.version;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public void setCrypto(Crypto crypto) {
            this.crypto = crypto;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeystoreV3)) {
                return false;
            }
            KeystoreV3 other = (KeystoreV3)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            Crypto this$crypto = this.getCrypto();
            Crypto other$crypto = other.getCrypto();
            if (this$crypto == null ? other$crypto != null : !((Object)this$crypto).equals(other$crypto)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            return this.getVersion() == other.getVersion();
        }

        protected boolean canEqual(Object other) {
            return other instanceof KeystoreV3;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            Crypto $crypto = this.getCrypto();
            result = result * 59 + ($crypto == null ? 43 : ((Object)$crypto).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            result = result * 59 + this.getVersion();
            return result;
        }

        public String toString() {
            return "KeyStore.KeystoreV3(address=" + this.getAddress() + ", crypto=" + this.getCrypto() + ", id=" + this.getId() + ", version=" + this.getVersion() + ")";
        }

        public static class KeystoreV3Builder {
            private String address;
            private Crypto crypto;
            private String id;
            private int version;

            KeystoreV3Builder() {
            }

            public KeystoreV3Builder address(String address) {
                this.address = address;
                return this;
            }

            public KeystoreV3Builder crypto(Crypto crypto) {
                this.crypto = crypto;
                return this;
            }

            public KeystoreV3Builder id(String id) {
                this.id = id;
                return this;
            }

            public KeystoreV3Builder version(int version) {
                this.version = version;
                return this;
            }

            public KeystoreV3 build() {
                return new KeystoreV3(this.address, this.crypto, this.id, this.version);
            }

            public String toString() {
                return "KeyStore.KeystoreV3.KeystoreV3Builder(address=" + this.address + ", crypto=" + this.crypto + ", id=" + this.id + ", version=" + this.version + ")";
            }
        }
    }
}

