/*
 * Decompiled with CFR 0.152.
 */
package com.firestack.laksaj.blockchain;

import com.firestack.laksaj.blockchain.TxBlockHeader;
import java.util.Arrays;

public class TxBlock {
    private Body body;
    private TxBlockHeader header;

    TxBlock(Body body, TxBlockHeader header) {
        this.body = body;
        this.header = header;
    }

    public static TxBlockBuilder builder() {
        return new TxBlockBuilder();
    }

    public Body getBody() {
        return this.body;
    }

    public TxBlockHeader getHeader() {
        return this.header;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public void setHeader(TxBlockHeader header) {
        this.header = header;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TxBlock)) {
            return false;
        }
        TxBlock other = (TxBlock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Body this$body = this.getBody();
        Body other$body = other.getBody();
        if (this$body == null ? other$body != null : !((Object)this$body).equals(other$body)) {
            return false;
        }
        TxBlockHeader this$header = this.getHeader();
        TxBlockHeader other$header = other.getHeader();
        return !(this$header == null ? other$header != null : !((Object)this$header).equals(other$header));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TxBlock;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Body $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        TxBlockHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        return result;
    }

    public String toString() {
        return "TxBlock(body=" + this.getBody() + ", header=" + this.getHeader() + ")";
    }

    public static class TxBlockBuilder {
        private Body body;
        private TxBlockHeader header;

        TxBlockBuilder() {
        }

        public TxBlockBuilder body(Body body) {
            this.body = body;
            return this;
        }

        public TxBlockBuilder header(TxBlockHeader header) {
            this.header = header;
            return this;
        }

        public TxBlock build() {
            return new TxBlock(this.body, this.header);
        }

        public String toString() {
            return "TxBlock.TxBlockBuilder(body=" + this.body + ", header=" + this.header + ")";
        }
    }

    public static class Body {
        private String HeaderSign;
        private MicroBlockInfo[] MicroBlockInfos;

        Body(String HeaderSign, MicroBlockInfo[] MicroBlockInfos) {
            this.HeaderSign = HeaderSign;
            this.MicroBlockInfos = MicroBlockInfos;
        }

        public static BodyBuilder builder() {
            return new BodyBuilder();
        }

        public String getHeaderSign() {
            return this.HeaderSign;
        }

        public MicroBlockInfo[] getMicroBlockInfos() {
            return this.MicroBlockInfos;
        }

        public void setHeaderSign(String HeaderSign) {
            this.HeaderSign = HeaderSign;
        }

        public void setMicroBlockInfos(MicroBlockInfo[] MicroBlockInfos) {
            this.MicroBlockInfos = MicroBlockInfos;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Body)) {
                return false;
            }
            Body other = (Body)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$HeaderSign = this.getHeaderSign();
            String other$HeaderSign = other.getHeaderSign();
            if (this$HeaderSign == null ? other$HeaderSign != null : !this$HeaderSign.equals(other$HeaderSign)) {
                return false;
            }
            return Arrays.deepEquals(this.getMicroBlockInfos(), other.getMicroBlockInfos());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Body;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $HeaderSign = this.getHeaderSign();
            result = result * 59 + ($HeaderSign == null ? 43 : $HeaderSign.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getMicroBlockInfos());
            return result;
        }

        public String toString() {
            return "TxBlock.Body(HeaderSign=" + this.getHeaderSign() + ", MicroBlockInfos=" + Arrays.deepToString(this.getMicroBlockInfos()) + ")";
        }

        public static class BodyBuilder {
            private String HeaderSign;
            private MicroBlockInfo[] MicroBlockInfos;

            BodyBuilder() {
            }

            public BodyBuilder HeaderSign(String HeaderSign) {
                this.HeaderSign = HeaderSign;
                return this;
            }

            public BodyBuilder MicroBlockInfos(MicroBlockInfo[] MicroBlockInfos) {
                this.MicroBlockInfos = MicroBlockInfos;
                return this;
            }

            public Body build() {
                return new Body(this.HeaderSign, this.MicroBlockInfos);
            }

            public String toString() {
                return "TxBlock.Body.BodyBuilder(HeaderSign=" + this.HeaderSign + ", MicroBlockInfos=" + Arrays.deepToString(this.MicroBlockInfos) + ")";
            }
        }
    }

    public static class MicroBlockInfo {
        private String MicroBlockHash;
        private int MicroBlockShardId;
        private String MicroBlockTxnRootHash;

        MicroBlockInfo(String MicroBlockHash, int MicroBlockShardId, String MicroBlockTxnRootHash) {
            this.MicroBlockHash = MicroBlockHash;
            this.MicroBlockShardId = MicroBlockShardId;
            this.MicroBlockTxnRootHash = MicroBlockTxnRootHash;
        }

        public static MicroBlockInfoBuilder builder() {
            return new MicroBlockInfoBuilder();
        }

        public String getMicroBlockHash() {
            return this.MicroBlockHash;
        }

        public int getMicroBlockShardId() {
            return this.MicroBlockShardId;
        }

        public String getMicroBlockTxnRootHash() {
            return this.MicroBlockTxnRootHash;
        }

        public void setMicroBlockHash(String MicroBlockHash) {
            this.MicroBlockHash = MicroBlockHash;
        }

        public void setMicroBlockShardId(int MicroBlockShardId) {
            this.MicroBlockShardId = MicroBlockShardId;
        }

        public void setMicroBlockTxnRootHash(String MicroBlockTxnRootHash) {
            this.MicroBlockTxnRootHash = MicroBlockTxnRootHash;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MicroBlockInfo)) {
                return false;
            }
            MicroBlockInfo other = (MicroBlockInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$MicroBlockHash = this.getMicroBlockHash();
            String other$MicroBlockHash = other.getMicroBlockHash();
            if (this$MicroBlockHash == null ? other$MicroBlockHash != null : !this$MicroBlockHash.equals(other$MicroBlockHash)) {
                return false;
            }
            if (this.getMicroBlockShardId() != other.getMicroBlockShardId()) {
                return false;
            }
            String this$MicroBlockTxnRootHash = this.getMicroBlockTxnRootHash();
            String other$MicroBlockTxnRootHash = other.getMicroBlockTxnRootHash();
            return !(this$MicroBlockTxnRootHash == null ? other$MicroBlockTxnRootHash != null : !this$MicroBlockTxnRootHash.equals(other$MicroBlockTxnRootHash));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MicroBlockInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $MicroBlockHash = this.getMicroBlockHash();
            result = result * 59 + ($MicroBlockHash == null ? 43 : $MicroBlockHash.hashCode());
            result = result * 59 + this.getMicroBlockShardId();
            String $MicroBlockTxnRootHash = this.getMicroBlockTxnRootHash();
            result = result * 59 + ($MicroBlockTxnRootHash == null ? 43 : $MicroBlockTxnRootHash.hashCode());
            return result;
        }

        public String toString() {
            return "TxBlock.MicroBlockInfo(MicroBlockHash=" + this.getMicroBlockHash() + ", MicroBlockShardId=" + this.getMicroBlockShardId() + ", MicroBlockTxnRootHash=" + this.getMicroBlockTxnRootHash() + ")";
        }

        public static class MicroBlockInfoBuilder {
            private String MicroBlockHash;
            private int MicroBlockShardId;
            private String MicroBlockTxnRootHash;

            MicroBlockInfoBuilder() {
            }

            public MicroBlockInfoBuilder MicroBlockHash(String MicroBlockHash) {
                this.MicroBlockHash = MicroBlockHash;
                return this;
            }

            public MicroBlockInfoBuilder MicroBlockShardId(int MicroBlockShardId) {
                this.MicroBlockShardId = MicroBlockShardId;
                return this;
            }

            public MicroBlockInfoBuilder MicroBlockTxnRootHash(String MicroBlockTxnRootHash) {
                this.MicroBlockTxnRootHash = MicroBlockTxnRootHash;
                return this;
            }

            public MicroBlockInfo build() {
                return new MicroBlockInfo(this.MicroBlockHash, this.MicroBlockShardId, this.MicroBlockTxnRootHash);
            }

            public String toString() {
                return "TxBlock.MicroBlockInfo.MicroBlockInfoBuilder(MicroBlockHash=" + this.MicroBlockHash + ", MicroBlockShardId=" + this.MicroBlockShardId + ", MicroBlockTxnRootHash=" + this.MicroBlockTxnRootHash + ")";
            }
        }
    }
}

