/*
 * Decompiled with CFR 0.152.
 */
package com.firestack.laksaj.blockchain;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;

public class DsBlockHeader {
    @SerializedName(value="BlockNum")
    private String blockNumber;
    @SerializedName(value="Difficulty")
    private int difficulty;
    @SerializedName(value="DifficultyDS")
    private int diffcultyDS;
    @SerializedName(value="GasPrice")
    private int gasPrice;
    @SerializedName(value="LeaderPubKey")
    private String leaderPublicKey;
    @SerializedName(value="PoWWinners")
    private String[] powWinners;
    @SerializedName(value="PrevHash")
    private String previousHash;
    @SerializedName(value="Timestamp")
    private String timestamp;

    DsBlockHeader(String blockNumber, int difficulty, int diffcultyDS, int gasPrice, String leaderPublicKey, String[] powWinners, String previousHash, String timestamp) {
        this.blockNumber = blockNumber;
        this.difficulty = difficulty;
        this.diffcultyDS = diffcultyDS;
        this.gasPrice = gasPrice;
        this.leaderPublicKey = leaderPublicKey;
        this.powWinners = powWinners;
        this.previousHash = previousHash;
        this.timestamp = timestamp;
    }

    public static DsBlockHeaderBuilder builder() {
        return new DsBlockHeaderBuilder();
    }

    public String getBlockNumber() {
        return this.blockNumber;
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public int getDiffcultyDS() {
        return this.diffcultyDS;
    }

    public int getGasPrice() {
        return this.gasPrice;
    }

    public String getLeaderPublicKey() {
        return this.leaderPublicKey;
    }

    public String[] getPowWinners() {
        return this.powWinners;
    }

    public String getPreviousHash() {
        return this.previousHash;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setBlockNumber(String blockNumber) {
        this.blockNumber = blockNumber;
    }

    public void setDifficulty(int difficulty) {
        this.difficulty = difficulty;
    }

    public void setDiffcultyDS(int diffcultyDS) {
        this.diffcultyDS = diffcultyDS;
    }

    public void setGasPrice(int gasPrice) {
        this.gasPrice = gasPrice;
    }

    public void setLeaderPublicKey(String leaderPublicKey) {
        this.leaderPublicKey = leaderPublicKey;
    }

    public void setPowWinners(String[] powWinners) {
        this.powWinners = powWinners;
    }

    public void setPreviousHash(String previousHash) {
        this.previousHash = previousHash;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DsBlockHeader)) {
            return false;
        }
        DsBlockHeader other = (DsBlockHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$blockNumber = this.getBlockNumber();
        String other$blockNumber = other.getBlockNumber();
        if (this$blockNumber == null ? other$blockNumber != null : !this$blockNumber.equals(other$blockNumber)) {
            return false;
        }
        if (this.getDifficulty() != other.getDifficulty()) {
            return false;
        }
        if (this.getDiffcultyDS() != other.getDiffcultyDS()) {
            return false;
        }
        if (this.getGasPrice() != other.getGasPrice()) {
            return false;
        }
        String this$leaderPublicKey = this.getLeaderPublicKey();
        String other$leaderPublicKey = other.getLeaderPublicKey();
        if (this$leaderPublicKey == null ? other$leaderPublicKey != null : !this$leaderPublicKey.equals(other$leaderPublicKey)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPowWinners(), other.getPowWinners())) {
            return false;
        }
        String this$previousHash = this.getPreviousHash();
        String other$previousHash = other.getPreviousHash();
        if (this$previousHash == null ? other$previousHash != null : !this$previousHash.equals(other$previousHash)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DsBlockHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $blockNumber = this.getBlockNumber();
        result = result * 59 + ($blockNumber == null ? 43 : $blockNumber.hashCode());
        result = result * 59 + this.getDifficulty();
        result = result * 59 + this.getDiffcultyDS();
        result = result * 59 + this.getGasPrice();
        String $leaderPublicKey = this.getLeaderPublicKey();
        result = result * 59 + ($leaderPublicKey == null ? 43 : $leaderPublicKey.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPowWinners());
        String $previousHash = this.getPreviousHash();
        result = result * 59 + ($previousHash == null ? 43 : $previousHash.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        return result;
    }

    public String toString() {
        return "DsBlockHeader(blockNumber=" + this.getBlockNumber() + ", difficulty=" + this.getDifficulty() + ", diffcultyDS=" + this.getDiffcultyDS() + ", gasPrice=" + this.getGasPrice() + ", leaderPublicKey=" + this.getLeaderPublicKey() + ", powWinners=" + Arrays.deepToString(this.getPowWinners()) + ", previousHash=" + this.getPreviousHash() + ", timestamp=" + this.getTimestamp() + ")";
    }

    public static class DsBlockHeaderBuilder {
        private String blockNumber;
        private int difficulty;
        private int diffcultyDS;
        private int gasPrice;
        private String leaderPublicKey;
        private String[] powWinners;
        private String previousHash;
        private String timestamp;

        DsBlockHeaderBuilder() {
        }

        public DsBlockHeaderBuilder blockNumber(String blockNumber) {
            this.blockNumber = blockNumber;
            return this;
        }

        public DsBlockHeaderBuilder difficulty(int difficulty) {
            this.difficulty = difficulty;
            return this;
        }

        public DsBlockHeaderBuilder diffcultyDS(int diffcultyDS) {
            this.diffcultyDS = diffcultyDS;
            return this;
        }

        public DsBlockHeaderBuilder gasPrice(int gasPrice) {
            this.gasPrice = gasPrice;
            return this;
        }

        public DsBlockHeaderBuilder leaderPublicKey(String leaderPublicKey) {
            this.leaderPublicKey = leaderPublicKey;
            return this;
        }

        public DsBlockHeaderBuilder powWinners(String[] powWinners) {
            this.powWinners = powWinners;
            return this;
        }

        public DsBlockHeaderBuilder previousHash(String previousHash) {
            this.previousHash = previousHash;
            return this;
        }

        public DsBlockHeaderBuilder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public DsBlockHeader build() {
            return new DsBlockHeader(this.blockNumber, this.difficulty, this.diffcultyDS, this.gasPrice, this.leaderPublicKey, this.powWinners, this.previousHash, this.timestamp);
        }

        public String toString() {
            return "DsBlockHeader.DsBlockHeaderBuilder(blockNumber=" + this.blockNumber + ", difficulty=" + this.difficulty + ", diffcultyDS=" + this.diffcultyDS + ", gasPrice=" + this.gasPrice + ", leaderPublicKey=" + this.leaderPublicKey + ", powWinners=" + Arrays.deepToString(this.powWinners) + ", previousHash=" + this.previousHash + ", timestamp=" + this.timestamp + ")";
        }
    }
}

