/*
 * Decompiled with CFR 0.152.
 */
package com.firestack.laksaj.contract;

import com.firestack.laksaj.account.Wallet;
import com.firestack.laksaj.contract.Contract;
import com.firestack.laksaj.contract.Value;
import com.firestack.laksaj.crypto.KeyTools;
import com.firestack.laksaj.jsonrpc.HttpProvider;
import com.firestack.laksaj.transaction.Transaction;
import com.firestack.laksaj.utils.ByteUtil;
import com.firestack.laksaj.utils.Validation;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ContractFactory {
    private Wallet signer;
    private HttpProvider provider;

    public static String getAddressForContract(Transaction tx) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        String senderAddress = KeyTools.getAddressFromPublicKey(tx.getSenderPubKey());
        messageDigest.update(ByteUtil.hexStringToByteArray(senderAddress));
        int nonce = 0;
        if (null != tx.getNonce() && !tx.getNonce().isEmpty()) {
            nonce = Integer.parseInt(tx.getNonce());
            --nonce;
        }
        String hexNonce = Validation.intToHex(nonce, 16);
        messageDigest.update(ByteUtil.hexStringToByteArray(hexNonce));
        byte[] bytes = messageDigest.digest();
        return ByteUtil.byteArrayToHexString(bytes).substring(24);
    }

    public Contract newContract(String code, Value[] init, String abi) {
        return new Contract(this, code, abi, null, init, null);
    }

    public Contract atContract(String address, String code, Value[] init, String abi) {
        return new Contract(this, code, abi, address, init, null);
    }

    ContractFactory(Wallet signer, HttpProvider provider) {
        this.signer = signer;
        this.provider = provider;
    }

    public static ContractFactoryBuilder builder() {
        return new ContractFactoryBuilder();
    }

    public Wallet getSigner() {
        return this.signer;
    }

    public HttpProvider getProvider() {
        return this.provider;
    }

    public void setSigner(Wallet signer) {
        this.signer = signer;
    }

    public void setProvider(HttpProvider provider) {
        this.provider = provider;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContractFactory)) {
            return false;
        }
        ContractFactory other = (ContractFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Wallet this$signer = this.getSigner();
        Wallet other$signer = other.getSigner();
        if (this$signer == null ? other$signer != null : !this$signer.equals(other$signer)) {
            return false;
        }
        HttpProvider this$provider = this.getProvider();
        HttpProvider other$provider = other.getProvider();
        return !(this$provider == null ? other$provider != null : !this$provider.equals(other$provider));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContractFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Wallet $signer = this.getSigner();
        result = result * 59 + ($signer == null ? 43 : $signer.hashCode());
        HttpProvider $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        return result;
    }

    public String toString() {
        return "ContractFactory(signer=" + this.getSigner() + ", provider=" + this.getProvider() + ")";
    }

    public static class ContractFactoryBuilder {
        private Wallet signer;
        private HttpProvider provider;

        ContractFactoryBuilder() {
        }

        public ContractFactoryBuilder signer(Wallet signer) {
            this.signer = signer;
            return this;
        }

        public ContractFactoryBuilder provider(HttpProvider provider) {
            this.provider = provider;
            return this;
        }

        public ContractFactory build() {
            return new ContractFactory(this.signer, this.provider);
        }

        public String toString() {
            return "ContractFactory.ContractFactoryBuilder(signer=" + this.signer + ", provider=" + this.provider + ")";
        }
    }
}

