/*
 * Decompiled with CFR 0.152.
 */
package org.feasy.cloud.swagger.conf;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.feasy.cloud.swagger.properties.SwaggerProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@EnableConfigurationProperties(value={SwaggerProperties.class})
@ConditionalOnProperty(prefix="swagger.api.enable", value={"true"}, matchIfMissing=true)
public class SwaggerConfig {
    private final SwaggerProperties swaggerProperties;
    @Value(value="${spring.profiles.active}")
    private String profilesActive;
    @Value(value="${spring.application.name}")
    private String applicationName;

    public SwaggerConfig(SwaggerProperties swaggerProperties) {
        this.swaggerProperties = swaggerProperties;
    }

    @Bean
    public Docket createRestApi() {
        List<ResponseMessage> responseMessageList = this.buildResponseMessageList();
        boolean isOpenSwagger = this.swaggerProperties.getEnable() && (this.profilesActive.contains("dev") || this.profilesActive.contains("test"));
        return new Docket(DocumentationType.SWAGGER_2).globalResponseMessage(RequestMethod.GET, responseMessageList).globalResponseMessage(RequestMethod.POST, responseMessageList).globalResponseMessage(RequestMethod.PUT, responseMessageList).globalResponseMessage(RequestMethod.DELETE, responseMessageList).enable(isOpenSwagger).apiInfo(new ApiInfoBuilder().title(this.applicationName.toUpperCase() + " RestFul Apis").description(this.applicationName.toUpperCase() + " RestFul Apis").termsOfServiceUrl("#").build()).select().apis(RequestHandlerSelectors.basePackage((String)this.getControllerPackage())).paths(PathSelectors.any()).build();
    }

    private List<ResponseMessage> buildResponseMessageList() {
        return new ArrayList<ResponseMessage>(){
            {
                this.add(new ResponseMessageBuilder().code(0).message("\u8bf7\u6c42\u6210\u529f").responseModel((ModelReference)new ModelRef("Result")).build());
                this.add(new ResponseMessageBuilder().code(-1).message("\u672a\u77e5\u9519\u8bef").responseModel((ModelReference)new ModelRef("Result")).build());
                this.add(new ResponseMessageBuilder().code(1001).message("\u7528\u6237\u8bf7\u6c42\u64cd\u4f5c\u5931\u8d25").responseModel((ModelReference)new ModelRef("Result")).build());
                this.add(new ResponseMessageBuilder().code(1002).message("Token\u975e\u6cd5").responseModel((ModelReference)new ModelRef("Result")).build());
                this.add(new ResponseMessageBuilder().code(1003).message("\u65e0\u6743\u8bbf\u95ee \u62d2\u7edd\u8bf7\u6c42").responseModel((ModelReference)new ModelRef("Result")).build());
                this.add(new ResponseMessageBuilder().code(1004).message("\u672a\u627e\u5230\u8bf7\u6c42\u7684\u8d44\u6e90 \u65e0\u6548\u7684\u8d44\u6e90").responseModel((ModelReference)new ModelRef("Result")).build());
                this.add(new ResponseMessageBuilder().code(1005).message("\u8bf7\u6c42\u592a\u8fc7\u9891\u7e41  \u9650\u6d41 \u9650\u5236\u8bbf\u95ee").responseModel((ModelReference)new ModelRef("Result")).build());
                this.add(new ResponseMessageBuilder().code(1006).message("\u8bf7\u6c42\u88ab\u91cd\u5b9a\u5411").responseModel((ModelReference)new ModelRef("Result")).build());
            }
        };
    }

    private String getControllerPackage() {
        if (StringUtils.isBlank((String)this.swaggerProperties.getPackagePath())) {
            return "org.feasy.cloud." + this.applicationName.split("-")[0];
        }
        return this.swaggerProperties.getPackagePath();
    }
}

