/*
 * Decompiled with CFR 0.152.
 */
package org.feasy.cloud.permission.api.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.feasy.cloud.permission.api.annotation.VerifyPermission;
import org.feasy.cloud.permission.api.entity.ApiDetail;
import org.feasy.cloud.permission.api.entity.ServerApis;
import org.feasy.cloud.permission.api.properties.ServerInterfacePublishProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class ServerApisBuilder {
    private static final Logger log = LoggerFactory.getLogger(ServerApisBuilder.class);

    public static ServerApis builderServerApis(WebApplicationContext applicationContext, ServerInterfacePublishProperties publishProperties) {
        ServerApis serverApis = ServerApisBuilder.buildServerApis(publishProperties);
        Set<ApiDetail> apiDetailSet = ServerApisBuilder.buildApiDetailArray(applicationContext, publishProperties);
        serverApis.setApis(new ArrayList<ApiDetail>(apiDetailSet));
        serverApis.setServerApiVersion(DigestUtils.md5Hex((String)JSONArray.toJSONString(apiDetailSet)));
        log.info("Local Apis Init...  {}", (Object)JSONObject.toJSONString((Object)serverApis));
        return serverApis;
    }

    private static Set<ApiDetail> buildApiDetailArray(WebApplicationContext applicationContext, ServerInterfacePublishProperties publishProperties) {
        TreeSet<ApiDetail> apiDetailSet = new TreeSet<ApiDetail>();
        RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)applicationContext.getBean(RequestMappingHandlerMapping.class);
        Map map = mapping.getHandlerMethods();
        map.forEach((mappingInfo, handlerMethod) -> {
            String classPackage = handlerMethod.getBeanType().getName();
            if (ServerApisBuilder.verifyClassPackageHasProperties(classPackage, publishProperties.getInterfacePackage())) {
                ApiDetail apiDetail = new ApiDetail();
                Method method = handlerMethod.getMethod();
                Object[] methodTypes = mappingInfo.getMethodsCondition().getMethods().toArray();
                Object[] methodPaths = mappingInfo.getPatternsCondition().getPatterns().toArray();
                if (method.isAnnotationPresent(VerifyPermission.class)) {
                    VerifyPermission verifyPermission = method.getAnnotation(VerifyPermission.class);
                    if (null != verifyPermission && verifyPermission.keys().length > 0) {
                        apiDetail.setPermissionKeys(StringUtils.join((Object[])verifyPermission.keys(), (String)","));
                    }
                    if (StringUtils.isNotBlank((CharSequence)verifyPermission.name())) {
                        apiDetail.setApiName(verifyPermission.name());
                    }
                }
                apiDetail.setApiName(methodPaths[0].toString());
                apiDetail.setApiPath("/" + publishProperties.getServerId() + methodPaths[0].toString());
                apiDetail.setApiType(methodTypes[0].toString());
                apiDetail.setServerId(publishProperties.getServerId());
                apiDetail.setServerName(publishProperties.getServerName());
                apiDetailSet.add(apiDetail);
            }
        });
        return apiDetailSet;
    }

    private static boolean verifyClassPackageHasProperties(String classPackage, String ... scanPackages) {
        for (String scanPackage : scanPackages) {
            if (!Pattern.matches(ServerApisBuilder.buildRegexPackage(scanPackage), classPackage)) continue;
            return true;
        }
        return false;
    }

    private static ServerApis buildServerApis(ServerInterfacePublishProperties publishProperties) {
        return new ServerApis().setServerId(publishProperties.getServerId()).setServerName(publishProperties.getServerName());
    }

    private static String buildRegexPackage(String scanPackage) {
        return scanPackage.replace("**", "[\\w]*") + ".[\\w]*";
    }
}

