/*
 * Decompiled with CFR 0.152.
 */
package org.feasy.cloud.permission.api.util;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.feasy.cloud.permission.api.entity.ServerApis;
import org.feasy.cloud.permission.api.global.ServerApisContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class PermissionServerApisClient {
    private static final Logger log = LoggerFactory.getLogger(PermissionServerApisClient.class);
    private Map<String, Integer> countGetServiceInstance = new ConcurrentHashMap<String, Integer>();
    private RestTemplate restTemplate = new RestTemplate();
    private final ServerApisContainer serverApisContainer;

    public PermissionServerApisClient(ServerApisContainer serverApisContainer) {
        this.serverApisContainer = serverApisContainer;
    }

    public boolean serviceInstancesUpLine(ServiceInstance serviceInstance) {
        String serviceId = serviceInstance.getServiceId();
        try {
            String url = serviceInstance.isSecure() ? "https://" + serviceInstance.getHost() + ":" + serviceInstance.getPort() + "/serverInterface/serverApiDetails" : "http://" + serviceInstance.getHost() + ":" + serviceInstance.getPort() + "/serverInterface/serverApiDetails";
            ServerApis serverApis = (ServerApis)this.restTemplate.getForObject(url, ServerApis.class, new Object[0]);
            this.serverApisContainer.addServerApis(serverApis);
            log.info("\u83b7\u53d6\u670d\u52a1API:{}", (Object)JSONObject.toJSONString((Object)serverApis));
        }
        catch (Exception e) {
            if (!this.countGetServiceInstance.containsKey(serviceId)) {
                this.countGetServiceInstance.put(serviceId, 0);
            }
            if (this.countGetServiceInstance.get(serviceId) > 9) {
                return true;
            }
            log.error("{}\u91cd\u8bd5\u83b7\u53d6\uff1a{}", (Object)serviceId, (Object)this.countGetServiceInstance.get(serviceId));
            this.countGetServiceInstance.put(serviceId, this.countGetServiceInstance.get(serviceId) + 1);
            return false;
        }
        return true;
    }

    public void serviceInstancesOffLine(String serviceId) {
        this.countGetServiceInstance.remove(serviceId);
        this.serverApisContainer.removeServerApis(serviceId);
    }
}

