/*
 * Decompiled with CFR 0.152.
 */
package org.feasy.cloud.permission.api.global;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.feasy.cloud.permission.api.entity.ApiDetail;
import org.feasy.cloud.permission.api.entity.ServerApis;
import org.feasy.cloud.permission.api.event.ServerApisAddEvent;
import org.feasy.cloud.permission.api.event.ServerApisRemoveEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class ServerApisContainer {
    private List<ApiDetail> allApiDetails = Collections.synchronizedList(new LinkedList());
    private Map<String, ServerApis> serverApisMap = new ConcurrentHashMap<String, ServerApis>();
    private final ApplicationEventPublisher publisher;

    public ServerApisContainer(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public ServerApisContainer(ApplicationEventPublisher publisher, ServerApis serverApis) {
        this.publisher = publisher;
        this.addServerApis(serverApis);
    }

    public void addServerApis(ServerApis serverApis) {
        this.serverApisMap.put(serverApis.getServerId(), serverApis);
        this.allApiDetails.addAll(serverApis.getApis());
        this.publisher.publishEvent((ApplicationEvent)new ServerApisAddEvent(serverApis));
    }

    public List<ApiDetail> listAllApiDetail() {
        return this.allApiDetails;
    }

    public void removeServerApis(String serviceId) {
        if (this.serverApisMap.containsKey(serviceId)) {
            this.publisher.publishEvent((ApplicationEvent)new ServerApisRemoveEvent(this.serverApisMap.get(serviceId)));
            this.allApiDetails.removeAll(this.serverApisMap.get(serviceId).getApis());
            this.serverApisMap.remove(serviceId);
        }
    }
}

