/*
 * Decompiled with CFR 0.152.
 */
package org.feasy.cloud.permission.api.event;

import com.alibaba.cloud.nacos.discovery.NacosServiceDiscovery;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.feasy.cloud.permission.api.event.WatchServerChangedEvent;
import org.feasy.cloud.permission.api.util.PermissionServerApisClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;

public class WatchServerChangedLocator
implements Ordered,
ApplicationListener<WatchServerChangedEvent> {
    private static final Logger log = LoggerFactory.getLogger(WatchServerChangedLocator.class);
    private Map<String, List<ServiceInstance>> serverInstanceMap = new ConcurrentHashMap<String, List<ServiceInstance>>();
    private final NacosServiceDiscovery nacosServiceDiscovery;
    private final PermissionServerApisClient serverApisClient;
    private final String applicationName;

    public WatchServerChangedLocator(NacosServiceDiscovery nacosServiceDiscovery, PermissionServerApisClient serverApisClient, String applicationName) {
        this.nacosServiceDiscovery = nacosServiceDiscovery;
        this.serverApisClient = serverApisClient;
        this.applicationName = applicationName;
    }

    public void onApplicationEvent(WatchServerChangedEvent event) {
        this.refreshServiceInstancesMap();
    }

    private void refreshServiceInstancesMap() {
        try {
            HashSet validServiceIds = new HashSet();
            this.nacosServiceDiscovery.getServices().forEach(serviceId -> {
                try {
                    if (!this.applicationName.equals(serviceId) && !this.nacosServiceDiscovery.getInstances(serviceId).isEmpty()) {
                        this.nacosServiceDiscovery.getInstances(serviceId).forEach(serviceInstance -> {
                            if (Boolean.parseBoolean((String)serviceInstance.getMetadata().get("nacos.healthy"))) {
                                validServiceIds.add(serviceId);
                            }
                        });
                    }
                }
                catch (NacosException e) {
                    e.printStackTrace();
                }
            });
            this.serverInstanceMap.forEach((key, value) -> {
                if (!validServiceIds.contains(key)) {
                    this.serverInstanceMap.remove(key);
                }
            });
            block2: for (String serviceId2 : validServiceIds) {
                List serviceInstancesGroup = this.nacosServiceDiscovery.getInstances(serviceId2);
                if (this.serverInstanceMap.containsKey(serviceId2) || serviceInstancesGroup.isEmpty()) continue;
                for (ServiceInstance serviceInstance : serviceInstancesGroup) {
                    if (!Boolean.parseBoolean((String)serviceInstance.getMetadata().get("nacos.healthy")) || !this.serviceInstancesUpLine(serviceInstance)) continue;
                    this.serverInstanceMap.put(serviceId2, serviceInstancesGroup);
                    continue block2;
                }
            }
        }
        catch (NacosException e) {
            log.error("Nacos\u670d\u52a1\u5fc3\u8df3\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    private void serviceInstancesOffLine(String serviceId) {
        this.serverApisClient.serviceInstancesOffLine(serviceId);
    }

    private boolean serviceInstancesUpLine(ServiceInstance serviceInstance) {
        return this.serverApisClient.serviceInstancesUpLine(serviceInstance);
    }

    public int getOrder() {
        return 1000;
    }
}

