/*
 * Decompiled with CFR 0.152.
 */
package org.feasy.cloud.permission.api.event;

import org.feasy.cloud.permission.api.event.WatchServerChangedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.HeartbeatMonitor;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.discovery.event.ParentHeartbeatEvent;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.Assert;

public class WatchServerChangedListener
implements ApplicationListener<ApplicationEvent> {
    private final ApplicationEventPublisher publisher;
    private HeartbeatMonitor monitor = new HeartbeatMonitor();
    private boolean applicationIsReady = false;

    public WatchServerChangedListener(ApplicationEventPublisher publisher) {
        Assert.notNull((Object)publisher, (String)"publisher may not be null");
        this.publisher = publisher;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationReadyEvent) {
            this.applicationIsReady = true;
        } else if (event instanceof ContextRefreshedEvent || event instanceof RefreshScopeRefreshedEvent || event instanceof InstanceRegisteredEvent) {
            this.reset();
        } else if (event instanceof ParentHeartbeatEvent) {
            ParentHeartbeatEvent e = (ParentHeartbeatEvent)event;
            this.resetIfNeeded(e.getValue());
        } else if (event instanceof HeartbeatEvent) {
            HeartbeatEvent e = (HeartbeatEvent)event;
            this.resetIfNeeded(e.getValue());
        }
    }

    private void resetIfNeeded(Object value) {
        if (this.monitor.update(value)) {
            this.reset();
        }
    }

    private void reset() {
        if (this.applicationIsReady) {
            this.publisher.publishEvent((ApplicationEvent)new WatchServerChangedEvent(this));
        }
    }
}

