/*
 * Decompiled with CFR 0.152.
 */
package org.feasy.cloud.permission.api.conf;

import com.alibaba.cloud.nacos.discovery.NacosServiceDiscovery;
import org.feasy.cloud.permission.api.entity.ServerApis;
import org.feasy.cloud.permission.api.event.WatchServerChangedListener;
import org.feasy.cloud.permission.api.event.WatchServerChangedLocator;
import org.feasy.cloud.permission.api.global.ServerApisContainer;
import org.feasy.cloud.permission.api.properties.ServerInterfaceSubscribeProperties;
import org.feasy.cloud.permission.api.util.PermissionServerApisClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ServerInterfaceSubscribeProperties.class})
@ConditionalOnProperty(prefix="server.interface.subscribe", name={"enable"}, havingValue="true", matchIfMissing=true)
public class ServerInterfaceSubscribeConfiguration {
    @Value(value="${spring.application.name}")
    private String applicationName;

    @Bean
    public WatchServerChangedListener serverChangedListener(ApplicationEventPublisher publisher) {
        return new WatchServerChangedListener(publisher);
    }

    @Bean
    public WatchServerChangedLocator serverChangedLocator(NacosServiceDiscovery nacosServiceDiscovery, PermissionServerApisClient serverApisClient) {
        return new WatchServerChangedLocator(nacosServiceDiscovery, serverApisClient, this.applicationName);
    }

    @Bean
    @ConditionalOnMissingBean(value={ServerApisContainer.class, ServerApis.class})
    public ServerApisContainer serverApisContainer(ApplicationEventPublisher publisher) {
        return new ServerApisContainer(publisher);
    }
}

