/*
 * Decompiled with CFR 0.152.
 */
package org.feasy.cloud.locks.util;

import java.util.concurrent.TimeUnit;
import org.feasy.cloud.locks.util.DistributedLockCallback;
import org.feasy.cloud.locks.util.DistributedLockTemplate;
import org.feasy.cloud.locks.util.LockType;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleDistributedLockTemplate
implements DistributedLockTemplate {
    private static final Logger log = LoggerFactory.getLogger(SingleDistributedLockTemplate.class);
    private RedissonClient redisson;

    public SingleDistributedLockTemplate() {
    }

    public SingleDistributedLockTemplate(RedissonClient redisson) {
        this.redisson = redisson;
    }

    @Override
    public <T> T lock(DistributedLockCallback<T> callback, LockType lockType) {
        return this.lock(callback, 5000L, DEFAULT_TIME_UNIT, lockType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T lock(DistributedLockCallback<T> callback, long leaseTime, TimeUnit timeUnit, LockType lockType) {
        RLock lock = this.getLock(callback.getLockName(), lockType);
        try {
            lock.lock(leaseTime, timeUnit);
            T t = callback.process();
            return t;
        }
        finally {
            if (lock != null && lock.isLocked()) {
                lock.unlock();
            }
        }
    }

    @Override
    public <T> T tryLock(DistributedLockCallback<T> callback, LockType lockType) {
        return this.tryLock(callback, 30000L, 5000L, DEFAULT_TIME_UNIT, lockType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T tryLock(DistributedLockCallback<T> callback, long waitTime, long leaseTime, TimeUnit timeUnit, LockType lockType) {
        RLock lock = this.getLock(callback.getLockName(), lockType);
        try {
            if (lock.tryLock(waitTime, leaseTime, timeUnit)) {
                T t = callback.process();
                return t;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (lock != null && lock.isLocked()) {
                lock.unlock();
            }
        }
        return null;
    }

    private RLock getLock(String key, LockType lockType) {
        switch (lockType) {
            case REENTRANT_LOCK: {
                return this.redisson.getLock(key);
            }
            case FAIR_LOCK: {
                return this.redisson.getFairLock(key);
            }
            case READ_LOCK: {
                return this.redisson.getReadWriteLock(key).readLock();
            }
            case WRITE_LOCK: {
                return this.redisson.getReadWriteLock(key).writeLock();
            }
        }
        throw new RuntimeException("do not support lock type:" + lockType.name());
    }
}

