/*
 * Decompiled with CFR 0.152.
 */
package org.feasy.cloud.locks.aspect;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.beanutils.PropertyUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.feasy.cloud.locks.DistributedLock;
import org.feasy.cloud.locks.util.DistributedLockCallback;
import org.feasy.cloud.locks.util.DistributedLockTemplate;
import org.feasy.cloud.locks.util.LockType;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DistributedLockAspect {
    private DistributedLockTemplate lockTemplate;
    private ExpressionParser parser = new SpelExpressionParser();
    private LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();

    @Pointcut(value="@annotation(org.feasy.cloud.locks.DistributedLock)")
    private void distributedLock() {
    }

    @Around(value="distributedLock()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        Class<?> targetClass = pjp.getTarget().getClass();
        String methodName = pjp.getSignature().getName();
        Class<?>[] parameterTypes = ((MethodSignature)pjp.getSignature()).getMethod().getParameterTypes();
        Method method = targetClass.getMethod(methodName, parameterTypes);
        Object[] arguments = pjp.getArgs();
        String lockName = this.getLockName(method, arguments);
        return this.lock(pjp, method, lockName);
    }

    @AfterThrowing(value="distributedLock()", throwing="ex")
    public void afterThrowing(Throwable ex) {
        throw new RuntimeException(ex);
    }

    public String getLockName(Method method, Object[] args) {
        Objects.requireNonNull(method);
        DistributedLock annotation = method.getAnnotation(DistributedLock.class);
        String lockName = annotation.lockName();
        String param = annotation.param();
        if (this.isEmpty(lockName) && args.length > 0) {
            if (this.isNotEmpty(param)) {
                Object arg = annotation.argNum() > 0 ? args[annotation.argNum() - 1] : args[0];
                lockName = String.valueOf(this.getParam(arg, param));
            } else if (annotation.argNum() > 0) {
                lockName = args[annotation.argNum() - 1].toString();
            }
        }
        if (this.isNotEmpty(lockName)) {
            String preLockName = annotation.lockNamePre();
            String postLockName = annotation.lockNamePost();
            String separator = annotation.separator();
            StringBuilder lName = new StringBuilder();
            if (this.isNotEmpty(preLockName)) {
                lName.append(preLockName).append(separator);
            }
            lName.append(lockName);
            if (this.isNotEmpty(postLockName)) {
                lName.append(separator).append(postLockName);
            }
            lockName = lName.toString();
            return lockName;
        }
        throw new IllegalArgumentException("Can't get or generate lockName accurately!");
    }

    public Object getParam(Object arg, String param) {
        if (this.isNotEmpty(param) && arg != null) {
            try {
                Object result = PropertyUtils.getProperty((Object)arg, (String)param);
                return result;
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(arg + "\u6ca1\u6709\u5c5e\u6027" + param + "\u6216\u672a\u5b9e\u73b0get\u65b9\u6cd5\u3002", e);
            }
            catch (Exception e) {
                throw new RuntimeException("", e);
            }
        }
        return null;
    }

    public Object lock(ProceedingJoinPoint pjp, Method method, String lockName) {
        DistributedLock annotation = method.getAnnotation(DistributedLock.class);
        LockType lockType = annotation.lockType();
        boolean tryLock = annotation.tryLock();
        if (tryLock) {
            return this.tryLock(pjp, annotation, lockName, lockType);
        }
        return this.lock(pjp, lockName, lockType);
    }

    public Object lock(final ProceedingJoinPoint pjp, final String lockName, LockType lockType) {
        return this.lockTemplate.lock(new DistributedLockCallback<Object>(){

            @Override
            public Object process() {
                return DistributedLockAspect.this.proceed(pjp);
            }

            @Override
            public String getLockName() {
                return lockName;
            }
        }, lockType);
    }

    public Object tryLock(final ProceedingJoinPoint pjp, DistributedLock annotation, final String lockName, LockType lockType) {
        long waitTime = annotation.waitTime();
        long leaseTime = annotation.leaseTime();
        TimeUnit timeUnit = annotation.timeUnit();
        return this.lockTemplate.tryLock(new DistributedLockCallback<Object>(){

            @Override
            public Object process() {
                return DistributedLockAspect.this.proceed(pjp);
            }

            @Override
            public String getLockName() {
                return lockName;
            }
        }, waitTime, leaseTime, timeUnit, lockType);
    }

    public Object proceed(ProceedingJoinPoint pjp) {
        try {
            return pjp.proceed();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private boolean isEmpty(Object str) {
        return str == null || "".equals(str);
    }

    private boolean isNotEmpty(Object str) {
        return !this.isEmpty(str);
    }
}

