/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.storage.ocfl;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
public class ResourceHeaders {
    private final String id;
    private final String parent;
    private final String archivalGroupId;
    private final String stateToken;
    private final String interactionModel;
    private final String mimeType;
    private final String filename;
    private final long contentSize;
    private final Collection<URI> digests;
    private final String externalUrl;
    private final String externalHandling;
    private final Instant createdDate;
    private final String createdBy;
    private final Instant lastModifiedDate;
    private final String lastModifiedBy;
    private final boolean archivalGroup;
    private final boolean objectRoot;
    private final boolean deleted;
    private final String contentPath;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ResourceHeaders original) {
        return new Builder(original);
    }

    private ResourceHeaders(Builder builder) {
        this(builder.id, builder.parent, builder.archivalGroupId, builder.stateToken, builder.interactionModel, builder.mimeType, builder.filename, builder.contentSize, builder.digests, builder.externalUrl, builder.externalHandling, builder.createdDate, builder.createdBy, builder.lastModifiedDate, builder.lastModifiedBy, builder.archivalGroup, builder.objectRoot, builder.deleted, builder.contentPath);
    }

    private ResourceHeaders(String id, String parent, String archivalGroupId, String stateToken, String interactionModel, String mimeType, String filename, long contentSize, Collection<URI> digests, String externalUrl, String externalHandling, Instant createdDate, String createdBy, Instant lastModifiedDate, String lastModifiedBy, boolean archivalGroup, boolean objectRoot, boolean deleted, String contentPath) {
        this.id = id;
        this.parent = parent;
        this.archivalGroupId = archivalGroupId;
        this.stateToken = stateToken;
        this.interactionModel = interactionModel;
        this.mimeType = mimeType;
        this.filename = filename;
        this.contentSize = contentSize;
        this.digests = digests == null ? Collections.emptyList() : (digests instanceof List ? Collections.unmodifiableList((List)digests) : (digests instanceof Set ? Collections.unmodifiableSet((Set)digests) : Collections.unmodifiableCollection(digests)));
        this.externalUrl = externalUrl;
        this.externalHandling = externalHandling;
        this.createdDate = createdDate;
        this.createdBy = createdBy;
        this.lastModifiedDate = lastModifiedDate;
        this.lastModifiedBy = lastModifiedBy;
        this.archivalGroup = archivalGroup;
        this.objectRoot = objectRoot;
        this.deleted = deleted;
        this.contentPath = contentPath;
    }

    public String getId() {
        return this.id;
    }

    public String getParent() {
        return this.parent;
    }

    public String getArchivalGroupId() {
        return this.archivalGroupId;
    }

    public String getStateToken() {
        return this.stateToken;
    }

    public String getInteractionModel() {
        return this.interactionModel;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getContentSize() {
        return this.contentSize;
    }

    public Collection<URI> getDigests() {
        return this.digests;
    }

    public String getExternalHandling() {
        return this.externalHandling;
    }

    public Instant getCreatedDate() {
        return this.createdDate;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Instant getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public String getExternalUrl() {
        return this.externalUrl;
    }

    public boolean isArchivalGroup() {
        return this.archivalGroup;
    }

    public boolean isObjectRoot() {
        if (this.isArchivalGroup()) {
            return true;
        }
        return this.objectRoot;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public String getContentPath() {
        return this.contentPath;
    }

    public String toString() {
        return "ResourceHeaders{id='" + this.id + "', parent='" + this.parent + "', archivalGroupId='" + this.archivalGroupId + "', stateToken='" + this.stateToken + "', interactionModel='" + this.interactionModel + "', mimeType='" + this.mimeType + "', filename='" + this.filename + "', contentSize=" + this.contentSize + ", digests=" + this.digests + ", externalUrl='" + this.externalUrl + "', externalHandling='" + this.externalHandling + "', createdDate=" + this.createdDate + ", createdBy='" + this.createdBy + "', lastModifiedDate=" + this.lastModifiedDate + ", lastModifiedBy='" + this.lastModifiedBy + "', archivalGroup=" + this.archivalGroup + ", objectRoot=" + this.objectRoot + ", deleted=" + this.deleted + ", contentPath='" + this.contentPath + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceHeaders that = (ResourceHeaders)o;
        return this.archivalGroup == that.archivalGroup && this.objectRoot == that.objectRoot && this.deleted == that.deleted && Objects.equals(this.id, that.id) && Objects.equals(this.parent, that.parent) && Objects.equals(this.archivalGroupId, that.archivalGroupId) && Objects.equals(this.stateToken, that.stateToken) && Objects.equals(this.interactionModel, that.interactionModel) && Objects.equals(this.mimeType, that.mimeType) && Objects.equals(this.filename, that.filename) && Objects.equals(this.contentSize, that.contentSize) && Objects.equals(this.digests, that.digests) && Objects.equals(this.externalUrl, that.externalUrl) && Objects.equals(this.externalHandling, that.externalHandling) && Objects.equals(this.createdDate, that.createdDate) && Objects.equals(this.createdBy, that.createdBy) && Objects.equals(this.lastModifiedDate, that.lastModifiedDate) && Objects.equals(this.lastModifiedBy, that.lastModifiedBy) && Objects.equals(this.contentPath, that.contentPath);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.parent, this.archivalGroupId, this.stateToken, this.interactionModel, this.mimeType, this.filename, this.contentSize, this.digests, this.externalUrl, this.externalHandling, this.createdDate, this.createdBy, this.lastModifiedDate, this.lastModifiedBy, this.archivalGroup, this.objectRoot, this.deleted, this.contentPath);
    }

    @JsonPOJOBuilder
    public static class Builder {
        private String id;
        private String parent;
        private String archivalGroupId;
        private String stateToken;
        private String interactionModel;
        private String mimeType;
        private String filename;
        private long contentSize = -1L;
        private Collection<URI> digests;
        private String externalUrl;
        private String externalHandling;
        private Instant createdDate;
        private String createdBy;
        private Instant lastModifiedDate;
        private String lastModifiedBy;
        private boolean archivalGroup;
        private boolean objectRoot;
        private boolean deleted;
        private String contentPath;

        public Builder() {
        }

        public Builder(ResourceHeaders original) {
            this.id = original.getId();
            this.parent = original.getParent();
            this.archivalGroupId = original.getArchivalGroupId();
            this.stateToken = original.getStateToken();
            this.interactionModel = original.getInteractionModel();
            this.mimeType = original.getMimeType();
            this.filename = original.getFilename();
            this.contentSize = original.getContentSize();
            this.digests = new ArrayList<URI>(original.getDigests());
            this.externalUrl = original.getExternalUrl();
            this.externalHandling = original.getExternalHandling();
            this.createdDate = original.getCreatedDate();
            this.createdBy = original.getCreatedBy();
            this.lastModifiedDate = original.getLastModifiedDate();
            this.lastModifiedBy = original.getLastModifiedBy();
            this.archivalGroup = original.isArchivalGroup();
            this.objectRoot = original.isObjectRoot();
            this.deleted = original.isDeleted();
            this.contentPath = original.getContentPath();
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withParent(String parent) {
            this.parent = parent;
            return this;
        }

        public Builder withArchivalGroupId(String archivalGroupId) {
            this.archivalGroupId = archivalGroupId;
            return this;
        }

        public Builder withStateToken(String stateToken) {
            this.stateToken = stateToken;
            return this;
        }

        public Builder withInteractionModel(String interactionModel) {
            this.interactionModel = interactionModel;
            return this;
        }

        public Builder withMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder withFilename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder withContentSize(long contentSize) {
            this.contentSize = contentSize;
            return this;
        }

        public Builder withDigests(Collection<URI> digests) {
            this.digests = digests;
            return this;
        }

        public Builder addDigest(URI digest) {
            if (this.digests == null) {
                this.digests = new ArrayList<URI>();
            }
            this.digests.add(digest);
            return this;
        }

        public Builder withExternalUrl(String externalUrl) {
            this.externalUrl = externalUrl;
            return this;
        }

        public Builder withExternalHandling(String externalHandling) {
            this.externalHandling = externalHandling;
            return this;
        }

        public Builder withCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public Builder withCreatedBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder withLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public Builder withLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public Builder withArchivalGroup(boolean archivalGroup) {
            this.archivalGroup = archivalGroup;
            return this;
        }

        public Builder withObjectRoot(boolean objectRoot) {
            this.objectRoot = objectRoot;
            return this;
        }

        public Builder withDeleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder withContentPath(String contentPath) {
            this.contentPath = contentPath;
            return this;
        }

        public ResourceHeaders build() {
            return new ResourceHeaders(this);
        }
    }
}

