/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.storage.ocfl;

import org.apache.commons.lang3.StringUtils;

public final class PersistencePaths {
    public static final String FCR_METADATA = "fcr:metadata";
    private static final String FCR_ACL = "fcr:acl";
    private static final String HEADER_DIR = ".fcrepo/";
    private static final String ROOT_PREFIX = "fcr-root";
    private static final String CONTAINER_PREFIX = "fcr-container";
    private static final String ACL_SUFFIX = "~fcr-acl";
    private static final String DESCRIPTION_SUFFIX = "~fcr-desc";
    private static final String RDF_EXTENSION = ".nt";
    private static final String JSON_EXTENSION = ".json";
    public static final String ROOT_HEADER_PATH = ".fcrepo/fcr-root.json";
    private final String contentFilePath;
    private final String headerFilePath;

    private PersistencePaths(String contentFilePath, String headerFilePath) {
        this.contentFilePath = contentFilePath;
        this.headerFilePath = headerFilePath;
    }

    public String getContentFilePath() {
        return this.contentFilePath;
    }

    public String getHeaderFilePath() {
        return this.headerFilePath;
    }

    public static String headerPath(String rootResourceId, String resourceId) {
        IdInfo info = PersistencePaths.analyze(rootResourceId, resourceId);
        return PersistencePaths.resolveHeaderPath(info);
    }

    public static PersistencePaths nonRdfResource(String rootResourceId, String resourceId) {
        IdInfo info = PersistencePaths.analyze(rootResourceId, resourceId);
        String headerPath = PersistencePaths.resolveHeaderPath(info);
        String contentPath = PersistencePaths.resolveContentPath(false, info);
        return new PersistencePaths(contentPath, headerPath);
    }

    public static PersistencePaths rdfResource(String rootResourceId, String resourceId) {
        IdInfo info = PersistencePaths.analyze(rootResourceId, resourceId);
        if (info.isAcl) {
            throw new IllegalArgumentException("You must use aclContentPath() for ACL resources.");
        }
        String headerPath = PersistencePaths.resolveHeaderPath(info);
        String contentPath = PersistencePaths.resolveContentPath(!info.isDescription, info);
        return new PersistencePaths(contentPath, headerPath);
    }

    public static PersistencePaths aclResource(boolean describesRdfResource, String rootResourceId, String resourceId) {
        IdInfo info = PersistencePaths.analyze(rootResourceId, resourceId);
        if (!info.isAcl) {
            throw new IllegalArgumentException("This function should only be called for ACL resources.");
        }
        String headerPath = PersistencePaths.resolveHeaderPath(info);
        String contentPath = PersistencePaths.resolveContentPath(describesRdfResource, info);
        return new PersistencePaths(contentPath, headerPath);
    }

    public static boolean isHeaderFile(String path) {
        return path.startsWith(HEADER_DIR);
    }

    private static String resolveContentPath(boolean isContainer, IdInfo info) {
        if (info.isRoot && isContainer) {
            if (info.isAcl) {
                return "fcr-container~fcr-acl.nt";
            }
            return "fcr-container.nt";
        }
        StringBuilder pathBuilder = new StringBuilder(info.relativeId);
        if (info.isDescription) {
            pathBuilder.append(DESCRIPTION_SUFFIX).append(RDF_EXTENSION);
        } else if (isContainer) {
            if (info.isAcl) {
                pathBuilder.append("/").append(CONTAINER_PREFIX).append(ACL_SUFFIX).append(RDF_EXTENSION);
            } else {
                pathBuilder.append("/").append(CONTAINER_PREFIX).append(RDF_EXTENSION);
            }
        } else if (info.isAcl) {
            pathBuilder.append(ACL_SUFFIX).append(RDF_EXTENSION);
        }
        return pathBuilder.toString();
    }

    private static String resolveHeaderPath(IdInfo info) {
        Object path = info.isRoot ? ROOT_PREFIX : info.relativeId;
        if (info.isAcl) {
            path = (String)path + ACL_SUFFIX;
        } else if (info.isDescription) {
            path = (String)path + DESCRIPTION_SUFFIX;
        }
        return PersistencePaths.headerPath((String)path);
    }

    private static String headerPath(String path) {
        return HEADER_DIR + path + JSON_EXTENSION;
    }

    private static IdInfo analyze(String rootResourceId, String resourceId) {
        if (rootResourceId.equals(resourceId)) {
            return IdInfo.root(resourceId);
        }
        if (!resourceId.startsWith(rootResourceId)) {
            throw new IllegalArgumentException(String.format("The resources %s and %s are unrelated", resourceId, rootResourceId));
        }
        String relative = resourceId.substring(rootResourceId.length() + 1);
        if (relative.equals(FCR_ACL)) {
            return IdInfo.rootAcl(StringUtils.substringBeforeLast((String)resourceId, (String)"/"));
        }
        if (relative.equals(FCR_METADATA)) {
            return IdInfo.rootDescription(StringUtils.substringBeforeLast((String)resourceId, (String)"/"));
        }
        IdInfo info = IdInfo.regular(resourceId, relative);
        if (relative.endsWith(FCR_ACL)) {
            info.isAcl = true;
            info.relativeId = StringUtils.substringBeforeLast((String)relative, (String)"/");
        } else if (relative.endsWith(FCR_METADATA)) {
            info.isDescription = true;
            info.relativeId = StringUtils.substringBeforeLast((String)relative, (String)"/");
        }
        return info;
    }

    private static class IdInfo {
        String resourceId;
        String relativeId;
        boolean isRoot;
        boolean isAcl;
        boolean isDescription;

        static IdInfo root(String resourceId) {
            String lastPart = resourceId.substring(resourceId.lastIndexOf(47) + 1);
            IdInfo info = new IdInfo(resourceId, lastPart);
            info.isRoot = true;
            return info;
        }

        static IdInfo rootAcl(String resourceId) {
            IdInfo info = IdInfo.root(resourceId);
            info.isAcl = true;
            return info;
        }

        static IdInfo rootDescription(String resourceId) {
            IdInfo info = IdInfo.root(resourceId);
            info.isDescription = true;
            return info;
        }

        static IdInfo regular(String resourceId, String relativeId) {
            return new IdInfo(resourceId, relativeId);
        }

        IdInfo(String resourceId, String relativeId) {
            this.resourceId = resourceId;
            this.relativeId = relativeId;
            this.isRoot = false;
            this.isAcl = false;
            this.isDescription = false;
        }
    }
}

