/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.storage.ocfl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import org.fcrepo.storage.ocfl.ResourceHeaders;

public class ResourceContent
implements AutoCloseable {
    private final ResourceHeaders headers;
    private final Optional<InputStream> contentStream;

    public ResourceContent(InputStream contentStream, ResourceHeaders headers) {
        this(Optional.ofNullable(contentStream), headers);
    }

    public ResourceContent(Optional<InputStream> contentStream, ResourceHeaders headers) {
        this.contentStream = Objects.requireNonNull(contentStream, "contentStream cannot be null");
        this.headers = Objects.requireNonNull(headers, "headers cannot be null");
    }

    public Optional<InputStream> getContentStream() {
        return this.contentStream;
    }

    public ResourceHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public void close() throws IOException {
        if (this.contentStream.isPresent()) {
            this.contentStream.get().close();
        }
    }
}

